/*
 * Decompiled with CFR 0.152.
 */
package box2dLight;

import box2dLight.Light;
import box2dLight.PositionalLight;
import box2dLight.RayHandler;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;

public class PointLight
extends PositionalLight {
    public PointLight(RayHandler rayHandler, int rays) {
        this(rayHandler, rays, Light.DefaultColor, 15.0f, 0.0f, 0.0f);
    }

    public PointLight(RayHandler rayHandler, int rays, Color color, float distance, float x, float y) {
        super(rayHandler, rays, color, distance, x, y, 0.0f);
    }

    @Override
    public void update() {
        this.updateBody();
        if (this.dirty) {
            this.setEndPoints();
        }
        if (this.cull()) {
            return;
        }
        if (this.staticLight && !this.dirty) {
            return;
        }
        this.dirty = false;
        this.updateMesh();
    }

    @Override
    public void setDistance(float dist) {
        this.distance = (dist *= RayHandler.gammaCorrectionParameter) < 0.01f ? 0.01f : dist;
        this.dirty = true;
    }

    void setEndPoints() {
        float angleNum = 360.0f / (float)(this.rayNum - 1);
        for (int i2 = 0; i2 < this.rayNum; ++i2) {
            float angle = angleNum * (float)i2;
            this.sin[i2] = MathUtils.sinDeg(angle);
            this.cos[i2] = MathUtils.cosDeg(angle);
            this.endX[i2] = this.distance * this.cos[i2];
            this.endY[i2] = this.distance * this.sin[i2];
        }
    }

    @Override
    @Deprecated
    public void setDirection(float directionDegree) {
    }
}

