/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.core;

import com.badlogic.ashley.core.Component;
import com.badlogic.gdx.utils.Bits;
import com.badlogic.gdx.utils.ObjectMap;

public final class ComponentType {
    private static ObjectMap<Class<? extends Component>, ComponentType> assignedComponentTypes = new ObjectMap();
    private static int typeIndex = 0;
    private final int index = typeIndex++;

    private ComponentType() {
    }

    public int getIndex() {
        return this.index;
    }

    public static ComponentType getFor(Class<? extends Component> componentType) {
        ComponentType type = assignedComponentTypes.get(componentType);
        if (type == null) {
            type = new ComponentType();
            assignedComponentTypes.put(componentType, type);
        }
        return type;
    }

    public static int getIndexFor(Class<? extends Component> componentType) {
        return ComponentType.getFor(componentType).getIndex();
    }

    public static Bits getBitsFor(Class<? extends Component> ... componentTypes) {
        Bits bits = new Bits();
        int typesLength = componentTypes.length;
        for (int i2 = 0; i2 < typesLength; ++i2) {
            bits.set(ComponentType.getIndexFor(componentTypes[i2]));
        }
        return bits;
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentType other = (ComponentType)obj;
        return this.index == other.index;
    }
}

