/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.core;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentOperationHandler;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.ashley.core.EntityManager;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.core.FamilyManager;
import com.badlogic.ashley.core.SystemManager;
import com.badlogic.ashley.signals.Listener;
import com.badlogic.ashley.signals.Signal;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.ReflectionException;

public class Engine {
    private static Family empty = Family.all(new Class[0]).get();
    private final Listener<Entity> componentAdded = new ComponentListener();
    private final Listener<Entity> componentRemoved = new ComponentListener();
    private SystemManager systemManager = new SystemManager(new EngineSystemListener());
    private EntityManager entityManager = new EntityManager(new EngineEntityListener());
    private ComponentOperationHandler componentOperationHandler = new ComponentOperationHandler(new EngineDelayedInformer());
    private FamilyManager familyManager = new FamilyManager(this.entityManager.getEntities());
    private boolean updating;

    public Entity createEntity() {
        return new Entity();
    }

    public <T extends Component> T createComponent(Class<T> componentType) {
        try {
            return (T)((Component)ClassReflection.newInstance(componentType));
        }
        catch (ReflectionException e) {
            return null;
        }
    }

    public void addEntity(Entity entity) {
        boolean delayed = this.updating || this.familyManager.notifying();
        this.entityManager.addEntity(entity, delayed);
    }

    public void removeEntity(Entity entity) {
        boolean delayed = this.updating || this.familyManager.notifying();
        this.entityManager.removeEntity(entity, delayed);
    }

    public void removeAllEntities() {
        boolean delayed = this.updating || this.familyManager.notifying();
        this.entityManager.removeAllEntities(delayed);
    }

    public ImmutableArray<Entity> getEntities() {
        return this.entityManager.getEntities();
    }

    public void addSystem(EntitySystem system) {
        this.systemManager.addSystem(system);
    }

    public void removeSystem(EntitySystem system) {
        this.systemManager.removeSystem(system);
    }

    public <T extends EntitySystem> T getSystem(Class<T> systemType) {
        return this.systemManager.getSystem(systemType);
    }

    public ImmutableArray<EntitySystem> getSystems() {
        return this.systemManager.getSystems();
    }

    public ImmutableArray<Entity> getEntitiesFor(Family family) {
        return this.familyManager.getEntitiesFor(family);
    }

    public void addEntityListener(EntityListener listener) {
        this.addEntityListener(empty, 0, listener);
    }

    public void addEntityListener(int priority, EntityListener listener) {
        this.addEntityListener(empty, priority, listener);
    }

    public void addEntityListener(Family family, EntityListener listener) {
        this.addEntityListener(family, 0, listener);
    }

    public void addEntityListener(Family family, int priority, EntityListener listener) {
        this.familyManager.addEntityListener(family, priority, listener);
    }

    public void removeEntityListener(EntityListener listener) {
        this.familyManager.removeEntityListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(float deltaTime) {
        if (this.updating) {
            throw new IllegalStateException("Cannot call update() on an Engine that is already updating.");
        }
        this.updating = true;
        ImmutableArray<EntitySystem> systems = this.systemManager.getSystems();
        try {
            for (int i2 = 0; i2 < systems.size(); ++i2) {
                EntitySystem system = systems.get(i2);
                if (system.checkProcessing()) {
                    system.update(deltaTime);
                }
                this.componentOperationHandler.processOperations();
                this.entityManager.processPendingOperations();
            }
        }
        finally {
            this.updating = false;
        }
    }

    protected void addEntityInternal(Entity entity) {
        entity.componentAdded.add(this.componentAdded);
        entity.componentRemoved.add(this.componentRemoved);
        entity.componentOperationHandler = this.componentOperationHandler;
        this.familyManager.updateFamilyMembership(entity);
    }

    protected void removeEntityInternal(Entity entity) {
        this.familyManager.updateFamilyMembership(entity);
        entity.componentAdded.remove(this.componentAdded);
        entity.componentRemoved.remove(this.componentRemoved);
        entity.componentOperationHandler = null;
    }

    private class EngineDelayedInformer
    implements ComponentOperationHandler.BooleanInformer {
        private EngineDelayedInformer() {
        }

        @Override
        public boolean value() {
            return Engine.this.updating;
        }
    }

    private class EngineEntityListener
    implements EntityListener {
        private EngineEntityListener() {
        }

        @Override
        public void entityAdded(Entity entity) {
            Engine.this.addEntityInternal(entity);
        }

        @Override
        public void entityRemoved(Entity entity) {
            Engine.this.removeEntityInternal(entity);
        }
    }

    private class EngineSystemListener
    implements SystemManager.SystemListener {
        private EngineSystemListener() {
        }

        @Override
        public void systemAdded(EntitySystem system) {
            system.addedToEngineInternal(Engine.this);
        }

        @Override
        public void systemRemoved(EntitySystem system) {
            system.removedFromEngineInternal(Engine.this);
        }
    }

    private class ComponentListener
    implements Listener<Entity> {
        private ComponentListener() {
        }

        @Override
        public void receive(Signal<Entity> signal, Entity object) {
            Engine.this.familyManager.updateFamilyMembership(object);
        }
    }
}

