/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.systems;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IntervalSystem;
import com.badlogic.ashley.utils.ImmutableArray;

public abstract class IntervalIteratingSystem
extends IntervalSystem {
    private Family family;
    private ImmutableArray<Entity> entities;

    public IntervalIteratingSystem(Family family, float interval) {
        this(family, interval, 0);
    }

    public IntervalIteratingSystem(Family family, float interval, int priority) {
        super(interval, priority);
        this.family = family;
    }

    @Override
    public void addedToEngine(Engine engine) {
        this.entities = engine.getEntitiesFor(this.family);
    }

    @Override
    protected void updateInterval() {
        for (int i2 = 0; i2 < this.entities.size(); ++i2) {
            this.processEntity(this.entities.get(i2));
        }
    }

    public ImmutableArray<Entity> getEntities() {
        return this.entities;
    }

    public Family getFamily() {
        return this.family;
    }

    protected abstract void processEntity(Entity var1);
}

