/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.systems;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;

public abstract class IteratingSystem
extends EntitySystem {
    private Family family;
    private ImmutableArray<Entity> entities;

    public IteratingSystem(Family family) {
        this(family, 0);
    }

    public IteratingSystem(Family family, int priority) {
        super(priority);
        this.family = family;
    }

    @Override
    public void addedToEngine(Engine engine) {
        this.entities = engine.getEntitiesFor(this.family);
    }

    @Override
    public void removedFromEngine(Engine engine) {
        this.entities = null;
    }

    @Override
    public void update(float deltaTime) {
        for (int i2 = 0; i2 < this.entities.size(); ++i2) {
            this.processEntity(this.entities.get(i2), deltaTime);
        }
    }

    public ImmutableArray<Entity> getEntities() {
        return this.entities;
    }

    public Family getFamily() {
        return this.family;
    }

    protected abstract void processEntity(Entity var1, float var2);
}

