/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.particles.renderers.ParticleControllerRenderData;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;

public abstract class ParticleSorter {
    static final Vector3 TMP_V1 = new Vector3();
    protected Camera camera;

    public abstract <T extends ParticleControllerRenderData> int[] sort(Array<T> var1);

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void ensureCapacity(int capacity) {
    }

    public static class Distance
    extends ParticleSorter {
        private float[] distances;
        private int[] particleIndices;
        private int[] particleOffsets;
        private int currentSize = 0;

        @Override
        public void ensureCapacity(int capacity) {
            if (this.currentSize < capacity) {
                this.distances = new float[capacity];
                this.particleIndices = new int[capacity];
                this.particleOffsets = new int[capacity];
                this.currentSize = capacity;
            }
        }

        @Override
        public <T extends ParticleControllerRenderData> int[] sort(Array<T> renderData) {
            float[] val = this.camera.view.val;
            float cx = val[2];
            float cy = val[6];
            float cz = val[10];
            int count = 0;
            int i2 = 0;
            for (ParticleControllerRenderData data : renderData) {
                int k = 0;
                int c = i2 + data.controller.particles.size;
                while (i2 < c) {
                    this.distances[i2] = cx * data.positionChannel.data[k + 0] + cy * data.positionChannel.data[k + 1] + cz * data.positionChannel.data[k + 2];
                    this.particleIndices[i2] = i2;
                    ++i2;
                    k += data.positionChannel.strideSize;
                }
                count += data.controller.particles.size;
            }
            this.qsort(0, count - 1);
            for (i2 = 0; i2 < count; ++i2) {
                this.particleOffsets[this.particleIndices[i2]] = i2;
            }
            return this.particleOffsets;
        }

        public void qsort(int si, int ei) {
            if (si < ei) {
                if (ei - si <= 8) {
                    for (int i2 = si; i2 <= ei; ++i2) {
                        for (int j = i2; j > si && this.distances[j - 1] > this.distances[j]; --j) {
                            float tmp = this.distances[j];
                            this.distances[j] = this.distances[j - 1];
                            this.distances[j - 1] = tmp;
                            int tmpIndex = this.particleIndices[j];
                            this.particleIndices[j] = this.particleIndices[j - 1];
                            this.particleIndices[j - 1] = tmpIndex;
                        }
                    }
                    return;
                }
                float pivot = this.distances[si];
                int i3 = si + 1;
                int particlesPivotIndex = this.particleIndices[si];
                for (int j = si + 1; j <= ei; ++j) {
                    if (!(pivot > this.distances[j])) continue;
                    if (j > i3) {
                        float tmp = this.distances[j];
                        this.distances[j] = this.distances[i3];
                        this.distances[i3] = tmp;
                        int tmpIndex = this.particleIndices[j];
                        this.particleIndices[j] = this.particleIndices[i3];
                        this.particleIndices[i3] = tmpIndex;
                    }
                    ++i3;
                }
                this.distances[si] = this.distances[i3 - 1];
                this.distances[i3 - 1] = pivot;
                this.particleIndices[si] = this.particleIndices[i3 - 1];
                this.particleIndices[i3 - 1] = particlesPivotIndex;
                this.qsort(si, i3 - 2);
                this.qsort(i3, ei);
            }
        }
    }

    public static class None
    extends ParticleSorter {
        int currentCapacity = 0;
        int[] indices;

        @Override
        public void ensureCapacity(int capacity) {
            if (this.currentCapacity < capacity) {
                this.indices = new int[capacity];
                for (int i2 = 0; i2 < capacity; ++i2) {
                    this.indices[i2] = i2;
                }
                this.currentCapacity = capacity;
            }
        }

        @Override
        public <T extends ParticleControllerRenderData> int[] sort(Array<T> renderData) {
            return this.indices;
        }
    }
}

