/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.g3d.utils.TextureBinder;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.IntBuffer;

public final class DefaultTextureBinder
implements TextureBinder {
    public static final int ROUNDROBIN = 0;
    public static final int LRU = 1;
    public static final int MAX_GLES_UNITS = 32;
    private final int offset;
    private final int count;
    private final GLTexture[] textures;
    private int[] unitsLRU;
    private final int method;
    private boolean reused;
    private int reuseCount = 0;
    private int bindCount = 0;
    private final TextureDescriptor tempDesc = new TextureDescriptor();
    private int currentTexture = 0;

    public DefaultTextureBinder(int method) {
        this(method, 0);
    }

    public DefaultTextureBinder(int method, int offset) {
        this(method, offset, -1);
    }

    public DefaultTextureBinder(int method, int offset, int count) {
        int max = Math.min(DefaultTextureBinder.getMaxTextureUnits(), 32);
        if (count < 0) {
            count = max - offset;
        }
        if (offset < 0 || count < 0 || offset + count > max) {
            throw new GdxRuntimeException("Illegal arguments");
        }
        this.method = method;
        this.offset = offset;
        this.count = count;
        this.textures = new GLTexture[count];
        this.unitsLRU = method == 1 ? new int[count] : null;
    }

    private static int getMaxTextureUnits() {
        IntBuffer buffer = BufferUtils.newIntBuffer(16);
        Gdx.gl.glGetIntegerv(34930, buffer);
        return buffer.get(0);
    }

    @Override
    public void begin() {
        for (int i2 = 0; i2 < this.count; ++i2) {
            this.textures[i2] = null;
            if (this.unitsLRU == null) continue;
            this.unitsLRU[i2] = i2;
        }
    }

    @Override
    public void end() {
        Gdx.gl.glActiveTexture(33984);
    }

    @Override
    public final int bind(TextureDescriptor textureDesc) {
        return this.bindTexture(textureDesc, false);
    }

    @Override
    public final int bind(GLTexture texture) {
        this.tempDesc.set(texture, null, null, null, null);
        return this.bindTexture(this.tempDesc, false);
    }

    private final int bindTexture(TextureDescriptor textureDesc, boolean rebind) {
        int result;
        Object texture = textureDesc.texture;
        this.reused = false;
        switch (this.method) {
            case 0: {
                int idx = this.bindTextureRoundRobin((GLTexture)texture);
                result = this.offset + idx;
                break;
            }
            case 1: {
                int idx = this.bindTextureLRU((GLTexture)texture);
                result = this.offset + idx;
                break;
            }
            default: {
                return -1;
            }
        }
        if (this.reused) {
            ++this.reuseCount;
            if (rebind) {
                ((GLTexture)texture).bind(result);
            } else {
                Gdx.gl.glActiveTexture(33984 + result);
            }
        } else {
            ++this.bindCount;
        }
        ((GLTexture)texture).unsafeSetWrap(textureDesc.uWrap, textureDesc.vWrap);
        ((GLTexture)texture).unsafeSetFilter(textureDesc.minFilter, textureDesc.magFilter);
        return result;
    }

    private final int bindTextureRoundRobin(GLTexture texture) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            int idx = (this.currentTexture + i2) % this.count;
            if (this.textures[idx] != texture) continue;
            this.reused = true;
            return idx;
        }
        this.currentTexture = (this.currentTexture + 1) % this.count;
        this.textures[this.currentTexture] = texture;
        texture.bind(this.offset + this.currentTexture);
        return this.currentTexture;
    }

    private final int bindTextureLRU(GLTexture texture) {
        int idx;
        int i2;
        for (i2 = 0; i2 < this.count; ++i2) {
            idx = this.unitsLRU[i2];
            if (this.textures[idx] == texture) {
                this.reused = true;
                break;
            }
            if (this.textures[idx] == null) break;
        }
        if (i2 >= this.count) {
            i2 = this.count - 1;
        }
        idx = this.unitsLRU[i2];
        while (i2 > 0) {
            this.unitsLRU[i2] = this.unitsLRU[i2 - 1];
            --i2;
        }
        this.unitsLRU[0] = idx;
        if (!this.reused) {
            this.textures[idx] = texture;
            texture.bind(this.offset + idx);
        }
        return idx;
    }

    @Override
    public final int getBindCount() {
        return this.bindCount;
    }

    @Override
    public final int getReuseCount() {
        return this.reuseCount;
    }

    @Override
    public final void resetCounts() {
        this.reuseCount = 0;
        this.bindCount = 0;
    }
}

