/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.particleeditor;

import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.tools.particleeditor.CustomShading;
import com.badlogic.gdx.tools.particleeditor.EditorPanel;
import com.badlogic.gdx.tools.particleeditor.ParticleEditor;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class CustomShadingPanel
extends EditorPanel {
    JPanel imagesPanel;
    JList imageList;
    DefaultListModel<String> imageListModel;
    String lastDir;
    final ParticleEditor editor;
    final CustomShading shading;

    public CustomShadingPanel(final ParticleEditor editor, String name, String description) {
        super(null, name, description);
        this.editor = editor;
        this.shading = editor.renderer.customShading;
        JPanel contentPanel = this.getContentPanel();
        JPanel shaderStagePanel = this.createShaderStagePanel(editor, contentPanel, true);
        contentPanel.add((Component)shaderStagePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        shaderStagePanel = this.createShaderStagePanel(editor, contentPanel, false);
        contentPanel.add((Component)shaderStagePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.imagesPanel = new JPanel(new GridBagLayout());
        contentPanel.add((Component)this.imagesPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.imagesPanel.add(new JLabel("Extra Texture Units"));
        this.imageListModel = new DefaultListModel();
        for (int i2 = 0; i2 < this.shading.extraTexturePaths.size; ++i2) {
            String path = this.shading.extraTexturePaths.get(i2);
            this.imageListModel.addElement(this.textureDisplayName(i2, path));
        }
        this.imageList = new JList<String>(this.imageListModel);
        this.imageList.setFixedCellWidth(200);
        this.imageList.setSelectionMode(0);
        this.imagesPanel.add((Component)this.imageList, new GridBagConstraints(0, 1, 1, 4, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        JButton addButton = new JButton("Add");
        this.imagesPanel.add((Component)addButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileDialog dialog = new FileDialog((Frame)editor, "Open Image", 0);
                if (CustomShadingPanel.this.lastDir != null) {
                    dialog.setDirectory(CustomShadingPanel.this.lastDir);
                }
                dialog.setVisible(true);
                String file = dialog.getFile();
                String dir = dialog.getDirectory();
                if (dir == null || file == null || file.trim().length() == 0) {
                    return;
                }
                CustomShadingPanel.this.lastDir = dir;
                CustomShadingPanel.this.addTexture(new File(dir, file).getAbsolutePath());
            }
        });
        JButton upButton = new JButton("\u2191");
        this.imagesPanel.add((Component)upButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = CustomShadingPanel.this.imageList.getSelectedIndex();
                if (index <= 0) {
                    return;
                }
                CustomShadingPanel.this.swapTexture(index, index - 1);
                CustomShadingPanel.this.imageList.setSelectedIndex(index - 1);
            }
        });
        JButton downButton = new JButton("\u2193");
        this.imagesPanel.add((Component)downButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = CustomShadingPanel.this.imageList.getSelectedIndex();
                if (index < 0 || index >= CustomShadingPanel.this.imageList.getModel().getSize() - 1) {
                    return;
                }
                ParticleEmitter emitter = editor.getEmitter();
                CustomShadingPanel.this.swapTexture(index, index + 1);
                CustomShadingPanel.this.imageList.setSelectedIndex(index + 1);
            }
        });
        JButton removeButton = new JButton("X");
        this.imagesPanel.add((Component)removeButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = CustomShadingPanel.this.imageList.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                CustomShadingPanel.this.removeTexture(index);
            }
        });
        JButton reloadButton = new JButton("Reload");
        this.imagesPanel.add((Component)reloadButton, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        reloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = CustomShadingPanel.this.imageList.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                CustomShadingPanel.this.reloadTexture(index);
            }
        });
    }

    private JPanel createShaderStagePanel(final ParticleEditor editor, JPanel contentPanel, final boolean isVertexShader) {
        JPanel buttonsPanel = new JPanel(new GridLayout(5, 1));
        JLabel label = new JLabel(isVertexShader ? "Vertex Shader" : "Frag. Shader");
        buttonsPanel.add(label);
        JButton defaultButton = new JButton("Default");
        buttonsPanel.add(defaultButton);
        defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (isVertexShader) {
                    CustomShadingPanel.this.shading.setVertexShaderFile(null);
                } else {
                    CustomShadingPanel.this.shading.setFragmentShaderFile(null);
                }
                CustomShadingPanel.this.displayErrors();
            }
        });
        JButton setButton = new JButton("Set");
        buttonsPanel.add(setButton);
        setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileDialog dialog = new FileDialog((Frame)editor, isVertexShader ? "Open Vertex Shader File" : "Open Fragment Shader File", 0);
                if (CustomShadingPanel.this.lastDir != null) {
                    dialog.setDirectory(CustomShadingPanel.this.lastDir);
                }
                dialog.setVisible(true);
                String file = dialog.getFile();
                String dir = dialog.getDirectory();
                if (dir == null || file == null || file.trim().length() == 0) {
                    return;
                }
                CustomShadingPanel.this.lastDir = dir;
                String path = new File(dir, file).getAbsolutePath();
                if (isVertexShader) {
                    CustomShadingPanel.this.shading.setVertexShaderFile(path);
                } else {
                    CustomShadingPanel.this.shading.setFragmentShaderFile(path);
                }
                CustomShadingPanel.this.displayErrors();
            }
        });
        JButton reloadButton = new JButton("Reload");
        buttonsPanel.add(reloadButton);
        reloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (isVertexShader) {
                    CustomShadingPanel.this.shading.reloadVertexShader();
                } else {
                    CustomShadingPanel.this.shading.reloadFragmentShader();
                }
                CustomShadingPanel.this.displayErrors();
            }
        });
        JButton showButton = new JButton("Show");
        buttonsPanel.add(showButton);
        showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JTextArea text = new JTextArea(isVertexShader ? CustomShadingPanel.this.shading.vertexShaderCode : CustomShadingPanel.this.shading.fragmentShaderCode);
                text.setEditable(false);
                JOptionPane.showMessageDialog(editor, text, isVertexShader ? "Current vertex shader code" : "Current fragment shader code", 1);
            }
        });
        return buttonsPanel;
    }

    protected void displayErrors() {
        if (this.shading.hasShaderErrors) {
            JOptionPane.showMessageDialog(this.editor, this.shading.shaderErrorMessage, "Shader Error", 0);
        } else if (this.shading.hasMissingSamplers) {
            JOptionPane.showMessageDialog(this.editor, this.shading.missingSamplerMessage, "Missing texture sampler", 2);
        }
    }

    private String textureDisplayName(int index, String path) {
        int unit = index + 1;
        return "u_texture" + unit + ": " + new File(path).getName();
    }

    protected void removeTexture(int index) {
        this.imageListModel.remove(index);
        this.shading.removeTexture(index);
        this.revalidate();
        this.displayErrors();
    }

    protected void swapTexture(int indexA, int indexB) {
        this.shading.swapTexture(indexA, indexB);
        String pathA = this.shading.extraTexturePaths.get(indexA);
        String pathB = this.shading.extraTexturePaths.get(indexB);
        this.imageListModel.set(indexA, this.textureDisplayName(indexA, pathA));
        this.imageListModel.set(indexB, this.textureDisplayName(indexB, pathB));
        this.revalidate();
        this.displayErrors();
    }

    protected void addTexture(String absolutePath) {
        this.imageListModel.addElement(this.textureDisplayName(this.imageListModel.getSize(), absolutePath));
        this.shading.addTexture(absolutePath);
        this.revalidate();
        this.displayErrors();
    }

    protected void reloadTexture(int index) {
        this.shading.reloadTexture(index);
        this.displayErrors();
    }
}

