/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.texturepacker;

import java.awt.image.BufferedImage;
import java.util.NoSuchElementException;

public class ColorBleedEffect {
    private static final int[] offsets = new int[]{-1, -1, 0, -1, 1, -1, -1, 0, 1, 0, -1, 1, 0, 1, 1, 1};

    public BufferedImage processImage(BufferedImage image, int maxIterations) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage processedImage = image.getType() == 2 ? image : new BufferedImage(width, height, 2);
        int[] rgb = image.getRGB(0, 0, width, height, null, 0, width);
        Mask mask = new Mask(rgb);
        int lastPending = -1;
        for (int iterations = 0; mask.pendingSize > 0 && mask.pendingSize != lastPending && iterations < maxIterations; ++iterations) {
            lastPending = mask.pendingSize;
            this.executeIteration(rgb, mask, width, height);
        }
        processedImage.setRGB(0, 0, width, height, rgb, 0, width);
        return processedImage;
    }

    private void executeIteration(int[] rgb, Mask mask, int width, int height) {
        Mask.MaskIterator iterator = mask.new Mask.MaskIterator();
        while (iterator.hasNext()) {
            int pixelIndex = iterator.next();
            int x = pixelIndex % width;
            int y = pixelIndex / width;
            int r = 0;
            int g = 0;
            int b = 0;
            int count = 0;
            int n = offsets.length;
            for (int i2 = 0; i2 < n; i2 += 2) {
                int column = x + offsets[i2];
                int row = y + offsets[i2 + 1];
                if (column < 0 || column >= width || row < 0 || row >= height) {
                    column = x;
                    row = y;
                    continue;
                }
                int currentPixelIndex = ColorBleedEffect.getPixelIndex(width, column, row);
                if (mask.isBlank(currentPixelIndex)) continue;
                int argb = rgb[currentPixelIndex];
                r += ColorBleedEffect.red(argb);
                g += ColorBleedEffect.green(argb);
                b += ColorBleedEffect.blue(argb);
                ++count;
            }
            if (count == 0) continue;
            rgb[pixelIndex] = ColorBleedEffect.argb(0, r / count, g / count, b / count);
            iterator.markAsInProgress();
        }
        iterator.reset();
    }

    private static int getPixelIndex(int width, int x, int y) {
        return y * width + x;
    }

    private static int red(int argb) {
        return argb >> 16 & 0xFF;
    }

    private static int green(int argb) {
        return argb >> 8 & 0xFF;
    }

    private static int blue(int argb) {
        return argb >> 0 & 0xFF;
    }

    private static int argb(int a, int r, int g, int b) {
        if (a < 0 || a > 255 || r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            throw new IllegalArgumentException("Invalid RGBA: " + r + ", " + g + "," + b + "," + a);
        }
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    private static class Mask {
        final boolean[] blank;
        final int[] pending;
        final int[] changing;
        int pendingSize;
        int changingSize;

        Mask(int[] rgb) {
            int n = rgb.length;
            this.blank = new boolean[n];
            this.pending = new int[n];
            this.changing = new int[n];
            for (int i2 = 0; i2 < n; ++i2) {
                if (Mask.alpha(rgb[i2]) != 0) continue;
                this.blank[i2] = true;
                this.pending[this.pendingSize] = i2;
                ++this.pendingSize;
            }
        }

        boolean isBlank(int index) {
            return this.blank[index];
        }

        int removeIndex(int index) {
            if (index >= this.pendingSize) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            int value = this.pending[index];
            --this.pendingSize;
            this.pending[index] = this.pending[this.pendingSize];
            return value;
        }

        private static int alpha(int argb) {
            return argb >> 24 & 0xFF;
        }

        class MaskIterator {
            private int index;

            MaskIterator() {
            }

            boolean hasNext() {
                return this.index < Mask.this.pendingSize;
            }

            int next() {
                if (this.index >= Mask.this.pendingSize) {
                    throw new NoSuchElementException(String.valueOf(this.index));
                }
                return Mask.this.pending[this.index++];
            }

            void markAsInProgress() {
                --this.index;
                Mask.this.changing[Mask.this.changingSize] = Mask.this.removeIndex(this.index);
                ++Mask.this.changingSize;
            }

            void reset() {
                this.index = 0;
                int n = Mask.this.changingSize;
                for (int i2 = 0; i2 < n; ++i2) {
                    Mask.this.blank[Mask.this.changing[i2]] = false;
                }
                Mask.this.changingSize = 0;
            }
        }
    }
}

