/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.texturepacker;

import com.badlogic.gdx.tools.FileProcessor;
import com.badlogic.gdx.tools.texturepacker.TexturePacker;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TexturePackerFileProcessor
extends FileProcessor {
    private final TexturePacker.Settings defaultSettings;
    private final TexturePacker.ProgressListener progress;
    private ObjectMap<File, TexturePacker.Settings> dirToSettings = new ObjectMap();
    private Json json = new Json();
    private String packFileName;
    private File root;
    ArrayList<File> ignoreDirs = new ArrayList();
    boolean countOnly;
    int packCount;

    public TexturePackerFileProcessor() {
        this(new TexturePacker.Settings(), "pack.atlas", null);
    }

    public TexturePackerFileProcessor(TexturePacker.Settings defaultSettings, String packFileName, TexturePacker.ProgressListener progress) {
        this.defaultSettings = defaultSettings;
        this.progress = progress;
        if (packFileName.toLowerCase().endsWith(defaultSettings.atlasExtension.toLowerCase())) {
            packFileName = packFileName.substring(0, packFileName.length() - defaultSettings.atlasExtension.length());
        }
        this.packFileName = packFileName;
        this.setFlattenOutput(true);
        this.addInputSuffix(".png", ".jpg", ".jpeg");
        this.setComparator(new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                return file1.getName().compareTo(file2.getName());
            }
        });
    }

    @Override
    public ArrayList<FileProcessor.Entry> process(File inputFile, File outputRoot) throws Exception {
        this.root = inputFile;
        final ArrayList settingsFiles = new ArrayList();
        FileProcessor settingsProcessor = new FileProcessor(){

            @Override
            protected void processFile(FileProcessor.Entry inputFile) throws Exception {
                settingsFiles.add(inputFile.inputFile);
            }
        };
        settingsProcessor.addInputRegex("pack\\.json");
        settingsProcessor.process(inputFile, null);
        Collections.sort(settingsFiles, new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                return file1.toString().length() - file2.toString().length();
            }
        });
        for (File settingsFile : settingsFiles) {
            TexturePacker.Settings settings = null;
            File parent = settingsFile.getParentFile();
            while (!parent.equals(this.root)) {
                settings = this.dirToSettings.get(parent = parent.getParentFile());
                if (settings == null) continue;
                settings = this.newSettings(settings);
                break;
            }
            if (settings == null) {
                settings = this.newSettings(this.defaultSettings);
            }
            this.merge(settings, settingsFile);
            this.dirToSettings.put(settingsFile.getParentFile(), settings);
        }
        this.countOnly = true;
        super.process(inputFile, outputRoot);
        this.countOnly = false;
        if (this.progress != null) {
            this.progress.start(1.0f);
        }
        ArrayList<FileProcessor.Entry> result = super.process(inputFile, outputRoot);
        if (this.progress != null) {
            this.progress.end();
        }
        return result;
    }

    void merge(TexturePacker.Settings settings, File settingsFile) {
        try {
            JsonValue root = new JsonReader().parse(new FileReader(settingsFile));
            if (root == null) {
                return;
            }
            this.json.readFields(settings, root);
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error reading settings file: " + settingsFile, ex);
        }
    }

    @Override
    public ArrayList<FileProcessor.Entry> process(File[] files, File outputRoot) throws Exception {
        if (this.countOnly && outputRoot.exists()) {
            this.deleteOutput(outputRoot);
        }
        return super.process(files, outputRoot);
    }

    protected void deleteOutput(File outputRoot) throws Exception {
        File settingsFile = new File(this.root, "pack.json");
        TexturePacker.Settings rootSettings = this.defaultSettings;
        if (settingsFile.exists()) {
            rootSettings = this.newSettings(rootSettings);
            this.merge(rootSettings, settingsFile);
        }
        String atlasExtension = rootSettings.atlasExtension == null ? "" : rootSettings.atlasExtension;
        atlasExtension = Pattern.quote(atlasExtension);
        int n = rootSettings.scale.length;
        for (int i2 = 0; i2 < n; ++i2) {
            FileProcessor deleteProcessor = new FileProcessor(){

                @Override
                protected void processFile(FileProcessor.Entry inputFile) throws Exception {
                    inputFile.inputFile.delete();
                }
            };
            deleteProcessor.setRecursive(false);
            File packFile = new File(rootSettings.getScaledPackFileName(this.packFileName, i2));
            String scaledPackFileName = packFile.getName();
            String prefix = packFile.getName();
            int dotIndex = prefix.lastIndexOf(46);
            if (dotIndex != -1) {
                prefix = prefix.substring(0, dotIndex);
            }
            deleteProcessor.addInputRegex("(?i)" + prefix + "-?\\d*\\.(png|jpg|jpeg)");
            deleteProcessor.addInputRegex("(?i)" + prefix + atlasExtension);
            String dir = packFile.getParent();
            if (dir == null) {
                deleteProcessor.process(outputRoot, null);
                continue;
            }
            if (!new File(outputRoot + "/" + dir).exists()) continue;
            deleteProcessor.process(outputRoot + "/" + dir, null);
        }
    }

    @Override
    protected void processDir(final FileProcessor.Entry inputDir, ArrayList<FileProcessor.Entry> files) throws Exception {
        if (this.ignoreDirs.contains(inputDir.inputFile)) {
            return;
        }
        TexturePacker.Settings settings = null;
        for (File parent = inputDir.inputFile; (settings = this.dirToSettings.get(parent)) == null && parent != null && !parent.equals(this.root); parent = parent.getParentFile()) {
        }
        if (settings == null) {
            settings = this.defaultSettings;
        }
        if (settings.ignore) {
            return;
        }
        if (settings.combineSubdirectories) {
            files = new FileProcessor(this){

                @Override
                protected void processDir(FileProcessor.Entry entryDir, ArrayList<FileProcessor.Entry> files) {
                    for (File file = entryDir.inputFile; file != null && !file.equals(inputDir.inputFile); file = file.getParentFile()) {
                        if (!new File(file, "pack.json").exists()) continue;
                        files.clear();
                        return;
                    }
                    if (!TexturePackerFileProcessor.this.countOnly) {
                        TexturePackerFileProcessor.this.ignoreDirs.add(entryDir.inputFile);
                    }
                }

                @Override
                protected void processFile(FileProcessor.Entry entry) {
                    this.addProcessedFile(entry);
                }
            }.process(inputDir.inputFile, null);
        }
        if (files.isEmpty()) {
            return;
        }
        if (this.countOnly) {
            ++this.packCount;
            return;
        }
        Collections.sort(files, new Comparator<FileProcessor.Entry>(){
            final Pattern digitSuffix = Pattern.compile("(.*?)(\\d+)$");

            @Override
            public int compare(FileProcessor.Entry entry1, FileProcessor.Entry entry2) {
                int compare;
                String full2;
                String full1 = entry1.inputFile.getName();
                int dotIndex = full1.lastIndexOf(46);
                if (dotIndex != -1) {
                    full1 = full1.substring(0, dotIndex);
                }
                if ((dotIndex = (full2 = entry2.inputFile.getName()).lastIndexOf(46)) != -1) {
                    full2 = full2.substring(0, dotIndex);
                }
                String name1 = full1;
                String name2 = full2;
                int num1 = 0;
                int num2 = 0;
                Matcher matcher = this.digitSuffix.matcher(full1);
                if (matcher.matches()) {
                    try {
                        num1 = Integer.parseInt(matcher.group(2));
                        name1 = matcher.group(1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((matcher = this.digitSuffix.matcher(full2)).matches()) {
                    try {
                        num2 = Integer.parseInt(matcher.group(2));
                        name2 = matcher.group(1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((compare = name1.compareTo(name2)) != 0 || num1 == num2) {
                    return compare;
                }
                return num1 - num2;
            }
        });
        if (!settings.silent) {
            try {
                System.out.println("Reading: " + inputDir.inputFile.getCanonicalPath());
            }
            catch (IOException ignored) {
                System.out.println("Reading: " + inputDir.inputFile.getAbsolutePath());
            }
        }
        if (this.progress != null) {
            this.progress.start(1.0f / (float)this.packCount);
            String inputPath = null;
            try {
                String rootPath = this.root.getCanonicalPath();
                inputPath = inputDir.inputFile.getCanonicalPath();
                if (inputPath.startsWith(rootPath) && (inputPath = inputPath.substring((rootPath = rootPath.replace('\\', '/')).length()).replace('\\', '/')).startsWith("/")) {
                    inputPath = inputPath.substring(1);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (inputPath == null || inputPath.length() == 0) {
                inputPath = inputDir.inputFile.getName();
            }
            this.progress.setMessage(inputPath);
        }
        TexturePacker packer = this.newTexturePacker(this.root, settings);
        for (FileProcessor.Entry file : files) {
            packer.addImage(file.inputFile);
        }
        this.pack(packer, inputDir);
        if (this.progress != null) {
            this.progress.end();
        }
    }

    protected void pack(TexturePacker packer, FileProcessor.Entry inputDir) {
        packer.pack(inputDir.outputDir, this.packFileName);
    }

    protected TexturePacker newTexturePacker(File root, TexturePacker.Settings settings) {
        TexturePacker packer = new TexturePacker(root, settings);
        packer.setProgressListener(this.progress);
        return packer;
    }

    protected TexturePacker.Settings newSettings(TexturePacker.Settings settings) {
        return new TexturePacker.Settings(settings);
    }

    public TexturePacker.ProgressListener getProgressListener() {
        return this.progress;
    }
}

