/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression;

public class CRC {
    public static int[] Table = new int[256];
    int _value = -1;

    public void Init() {
        this._value = -1;
    }

    public void Update(byte[] data, int offset, int size) {
        for (int i2 = 0; i2 < size; ++i2) {
            this._value = Table[(this._value ^ data[offset + i2]) & 0xFF] ^ this._value >>> 8;
        }
    }

    public void Update(byte[] data) {
        int size = data.length;
        for (int i2 = 0; i2 < size; ++i2) {
            this._value = Table[(this._value ^ data[i2]) & 0xFF] ^ this._value >>> 8;
        }
    }

    public void UpdateByte(int b) {
        this._value = Table[(this._value ^ b) & 0xFF] ^ this._value >>> 8;
    }

    public int GetDigest() {
        return ~this._value;
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            int r = i2;
            for (int j = 0; j < 8; ++j) {
                if ((r & 1) != 0) {
                    r = r >>> 1 ^ 0xEDB88320;
                    continue;
                }
                r >>>= 1;
            }
            CRC.Table[i2] = r;
        }
    }
}

