/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.StaticCodeBook;
import com.jcraft.jorbis.Util;

class CodeBook {
    int dim;
    int entries;
    StaticCodeBook c = new StaticCodeBook();
    float[] valuelist;
    int[] codelist;
    DecodeAux decode_tree;
    private int[] t = new int[15];

    CodeBook() {
    }

    int encode(int a, Buffer b) {
        b.write(this.codelist[a], this.c.lengthlist[a]);
        return this.c.lengthlist[a];
    }

    int errorv(float[] a) {
        int best = this.best(a, 1);
        for (int k = 0; k < this.dim; ++k) {
            a[k] = this.valuelist[best * this.dim + k];
        }
        return best;
    }

    int encodev(int best, float[] a, Buffer b) {
        for (int k = 0; k < this.dim; ++k) {
            a[k] = this.valuelist[best * this.dim + k];
        }
        return this.encode(best, b);
    }

    int encodevs(float[] a, Buffer b, int step, int addmul) {
        int best = this.besterror(a, step, addmul);
        return this.encode(best, b);
    }

    synchronized int decodevs_add(float[] a, int offset, Buffer b, int n) {
        int i2;
        int step = n / this.dim;
        if (this.t.length < step) {
            this.t = new int[step];
        }
        for (i2 = 0; i2 < step; ++i2) {
            int entry = this.decode(b);
            if (entry == -1) {
                return -1;
            }
            this.t[i2] = entry * this.dim;
        }
        i2 = 0;
        int o = 0;
        while (i2 < this.dim) {
            for (int j = 0; j < step; ++j) {
                int n2 = offset + o + j;
                a[n2] = a[n2] + this.valuelist[this.t[j] + i2];
            }
            ++i2;
            o += step;
        }
        return 0;
    }

    int decodev_add(float[] a, int offset, Buffer b, int n) {
        if (this.dim > 8) {
            int i2 = 0;
            while (i2 < n) {
                int entry = this.decode(b);
                if (entry == -1) {
                    return -1;
                }
                int t = entry * this.dim;
                int j = 0;
                while (j < this.dim) {
                    int n2 = offset + i2++;
                    a[n2] = a[n2] + this.valuelist[t + j++];
                }
            }
        } else {
            int i3 = 0;
            while (i3 < n) {
                int entry = this.decode(b);
                if (entry == -1) {
                    return -1;
                }
                int t = entry * this.dim;
                int j = 0;
                switch (this.dim) {
                    case 8: {
                        int n3 = offset + i3++;
                        a[n3] = a[n3] + this.valuelist[t + j++];
                    }
                    case 7: {
                        int n4 = offset + i3++;
                        a[n4] = a[n4] + this.valuelist[t + j++];
                    }
                    case 6: {
                        int n5 = offset + i3++;
                        a[n5] = a[n5] + this.valuelist[t + j++];
                    }
                    case 5: {
                        int n6 = offset + i3++;
                        a[n6] = a[n6] + this.valuelist[t + j++];
                    }
                    case 4: {
                        int n7 = offset + i3++;
                        a[n7] = a[n7] + this.valuelist[t + j++];
                    }
                    case 3: {
                        int n8 = offset + i3++;
                        a[n8] = a[n8] + this.valuelist[t + j++];
                    }
                    case 2: {
                        int n9 = offset + i3++;
                        a[n9] = a[n9] + this.valuelist[t + j++];
                    }
                    case 1: {
                        int n10 = offset + i3++;
                        a[n10] = a[n10] + this.valuelist[t + j++];
                    }
                }
            }
        }
        return 0;
    }

    int decodev_set(float[] a, int offset, Buffer b, int n) {
        int i2 = 0;
        while (i2 < n) {
            int entry = this.decode(b);
            if (entry == -1) {
                return -1;
            }
            int t = entry * this.dim;
            int j = 0;
            while (j < this.dim) {
                a[offset + i2++] = this.valuelist[t + j++];
            }
        }
        return 0;
    }

    int decodevv_add(float[][] a, int offset, int ch, Buffer b, int n) {
        int chptr = 0;
        int i2 = offset / ch;
        while (i2 < (offset + n) / ch) {
            int entry = this.decode(b);
            if (entry == -1) {
                return -1;
            }
            int t = entry * this.dim;
            for (int j = 0; j < this.dim; ++j) {
                float[] fArray = a[chptr++];
                int n2 = i2++;
                fArray[n2] = fArray[n2] + this.valuelist[t + j];
                if (chptr != ch) continue;
                chptr = 0;
            }
        }
        return 0;
    }

    int decode(Buffer b) {
        int ptr = 0;
        DecodeAux t = this.decode_tree;
        int lok = b.look(t.tabn);
        if (lok >= 0) {
            ptr = t.tab[lok];
            b.adv(t.tabl[lok]);
            if (ptr <= 0) {
                return -ptr;
            }
        }
        do {
            switch (b.read1()) {
                case 0: {
                    ptr = t.ptr0[ptr];
                    break;
                }
                case 1: {
                    ptr = t.ptr1[ptr];
                    break;
                }
                default: {
                    return -1;
                }
            }
        } while (ptr > 0);
        return -ptr;
    }

    int decodevs(float[] a, int index, Buffer b, int step, int addmul) {
        int entry = this.decode(b);
        if (entry == -1) {
            return -1;
        }
        switch (addmul) {
            case -1: {
                int i2 = 0;
                int o = 0;
                while (i2 < this.dim) {
                    a[index + o] = this.valuelist[entry * this.dim + i2];
                    ++i2;
                    o += step;
                }
                break;
            }
            case 0: {
                int i3 = 0;
                int o = 0;
                while (i3 < this.dim) {
                    int n = index + o;
                    a[n] = a[n] + this.valuelist[entry * this.dim + i3];
                    ++i3;
                    o += step;
                }
                break;
            }
            case 1: {
                int i4 = 0;
                int o = 0;
                while (i4 < this.dim) {
                    int n = index + o;
                    a[n] = a[n] * this.valuelist[entry * this.dim + i4];
                    ++i4;
                    o += step;
                }
                break;
            }
        }
        return entry;
    }

    int best(float[] a, int step) {
        int besti = -1;
        float best = 0.0f;
        int e = 0;
        for (int i2 = 0; i2 < this.entries; ++i2) {
            if (this.c.lengthlist[i2] > 0) {
                float _this = CodeBook.dist(this.dim, this.valuelist, e, a, step);
                if (besti == -1 || _this < best) {
                    best = _this;
                    besti = i2;
                }
            }
            e += this.dim;
        }
        return besti;
    }

    int besterror(float[] a, int step, int addmul) {
        int best = this.best(a, step);
        switch (addmul) {
            case 0: {
                int i2 = 0;
                int o = 0;
                while (i2 < this.dim) {
                    int n = o;
                    a[n] = a[n] - this.valuelist[best * this.dim + i2];
                    ++i2;
                    o += step;
                }
                break;
            }
            case 1: {
                int i3 = 0;
                int o = 0;
                while (i3 < this.dim) {
                    float val = this.valuelist[best * this.dim + i3];
                    if (val == 0.0f) {
                        a[o] = 0.0f;
                    } else {
                        int n = o;
                        a[n] = a[n] / val;
                    }
                    ++i3;
                    o += step;
                }
                break;
            }
        }
        return best;
    }

    void clear() {
    }

    private static float dist(int el, float[] ref, int index, float[] b, int step) {
        float acc = 0.0f;
        for (int i2 = 0; i2 < el; ++i2) {
            float val = ref[index + i2] - b[i2 * step];
            acc += val * val;
        }
        return acc;
    }

    int init_decode(StaticCodeBook s) {
        this.c = s;
        this.entries = s.entries;
        this.dim = s.dim;
        this.valuelist = s.unquantize();
        this.decode_tree = this.make_decode_tree();
        if (this.decode_tree == null) {
            this.clear();
            return -1;
        }
        return 0;
    }

    static int[] make_words(int[] l, int n) {
        int i2;
        int[] marker = new int[33];
        int[] r = new int[n];
        for (i2 = 0; i2 < n; ++i2) {
            int length = l[i2];
            if (length <= 0) continue;
            int entry = marker[length];
            if (length < 32 && entry >>> length != 0) {
                return null;
            }
            r[i2] = entry;
            int j = length;
            while (j > 0) {
                if ((marker[j] & 1) != 0) {
                    if (j == 1) {
                        marker[1] = marker[1] + 1;
                        break;
                    }
                    marker[j] = marker[j - 1] << 1;
                    break;
                }
                int n2 = j--;
                marker[n2] = marker[n2] + 1;
            }
            for (j = length + 1; j < 33 && marker[j] >>> 1 == entry; ++j) {
                entry = marker[j];
                marker[j] = marker[j - 1] << 1;
            }
        }
        for (i2 = 0; i2 < n; ++i2) {
            int temp = 0;
            for (int j = 0; j < l[i2]; ++j) {
                temp <<= 1;
                temp |= r[i2] >>> j & 1;
            }
            r[i2] = temp;
        }
        return r;
    }

    DecodeAux make_decode_tree() {
        int top = 0;
        DecodeAux t = new DecodeAux();
        t.ptr0 = new int[this.entries * 2];
        int[] ptr0 = t.ptr0;
        t.ptr1 = new int[this.entries * 2];
        int[] ptr1 = t.ptr1;
        int[] codelist = CodeBook.make_words(this.c.lengthlist, this.c.entries);
        if (codelist == null) {
            return null;
        }
        t.aux = this.entries * 2;
        for (int i2 = 0; i2 < this.entries; ++i2) {
            int j;
            if (this.c.lengthlist[i2] <= 0) continue;
            int ptr = 0;
            for (j = 0; j < this.c.lengthlist[i2] - 1; ++j) {
                int bit = codelist[i2] >>> j & 1;
                if (bit == 0) {
                    if (ptr0[ptr] == 0) {
                        ptr0[ptr] = ++top;
                    }
                    ptr = ptr0[ptr];
                    continue;
                }
                if (ptr1[ptr] == 0) {
                    ptr1[ptr] = ++top;
                }
                ptr = ptr1[ptr];
            }
            if ((codelist[i2] >>> j & 1) == 0) {
                ptr0[ptr] = -i2;
                continue;
            }
            ptr1[ptr] = -i2;
        }
        t.tabn = Util.ilog(this.entries) - 4;
        if (t.tabn < 5) {
            t.tabn = 5;
        }
        int n = 1 << t.tabn;
        t.tab = new int[n];
        t.tabl = new int[n];
        for (int i3 = 0; i3 < n; ++i3) {
            int p = 0;
            int j = 0;
            for (j = 0; j < t.tabn && (p > 0 || j == 0); ++j) {
                p = (i3 & 1 << j) != 0 ? ptr1[p] : ptr0[p];
            }
            t.tab[i3] = p;
            t.tabl[i3] = j;
        }
        return t;
    }

    class DecodeAux {
        int[] tab;
        int[] tabl;
        int tabn;
        int[] ptr0;
        int[] ptr1;
        int aux;

        DecodeAux() {
        }
    }
}

