/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jorbis.Drft;

class Lpc {
    Drft fft = new Drft();
    int ln;
    int m;

    Lpc() {
    }

    static float lpc_from_data(float[] data, float[] lpc, int n, int m) {
        int i2;
        float[] aut = new float[m + 1];
        int j = m + 1;
        while (j-- != 0) {
            float d = 0.0f;
            for (i2 = j; i2 < n; ++i2) {
                d += data[i2] * data[i2 - j];
            }
            aut[j] = d;
        }
        float error = aut[0];
        for (i2 = 0; i2 < m; ++i2) {
            float r = -aut[i2 + 1];
            if (error == 0.0f) {
                for (int k = 0; k < m; ++k) {
                    lpc[k] = 0.0f;
                }
                return 0.0f;
            }
            for (j = 0; j < i2; ++j) {
                r -= lpc[j] * aut[i2 - j];
            }
            lpc[i2] = r /= error;
            for (j = 0; j < i2 / 2; ++j) {
                float tmp = lpc[j];
                int n2 = j;
                lpc[n2] = lpc[n2] + r * lpc[i2 - 1 - j];
                int n3 = i2 - 1 - j;
                lpc[n3] = lpc[n3] + r * tmp;
            }
            if (i2 % 2 != 0) {
                int n4 = j;
                lpc[n4] = lpc[n4] + lpc[j] * r;
            }
            error = (float)((double)error * (1.0 - (double)(r * r)));
        }
        return error;
    }

    float lpc_from_curve(float[] curve, float[] lpc) {
        int i2;
        int n = this.ln;
        float[] work = new float[n + n];
        float fscale = (float)(0.5 / (double)n);
        for (i2 = 0; i2 < n; ++i2) {
            work[i2 * 2] = curve[i2] * fscale;
            work[i2 * 2 + 1] = 0.0f;
        }
        work[n * 2 - 1] = curve[n - 1] * fscale;
        this.fft.backward(work);
        i2 = 0;
        int j = (n *= 2) / 2;
        while (i2 < n / 2) {
            float temp = work[i2];
            work[i2++] = work[j];
            work[j++] = temp;
        }
        return Lpc.lpc_from_data(work, lpc, n, this.m);
    }

    void init(int mapped, int m) {
        this.ln = mapped;
        this.m = m;
        this.fft.init(mapped * 2);
    }

    void clear() {
        this.fft.clear();
    }

    static float FAST_HYPOT(float a, float b) {
        return (float)Math.sqrt(a * a + b * b);
    }

    void lpc_to_curve(float[] curve, float[] lpc, float amp) {
        int i2;
        for (i2 = 0; i2 < this.ln * 2; ++i2) {
            curve[i2] = 0.0f;
        }
        if (amp == 0.0f) {
            return;
        }
        for (i2 = 0; i2 < this.m; ++i2) {
            curve[i2 * 2 + 1] = lpc[i2] / (4.0f * amp);
            curve[i2 * 2 + 2] = -lpc[i2] / (4.0f * amp);
        }
        this.fft.backward(curve);
        int l2 = this.ln * 2;
        float unit = (float)(1.0 / (double)amp);
        curve[0] = (float)(1.0 / (double)(curve[0] * 2.0f + unit));
        for (int i3 = 1; i3 < this.ln; ++i3) {
            float real = curve[i3] + curve[l2 - i3];
            float imag = curve[i3] - curve[l2 - i3];
            float a = real + unit;
            curve[i3] = (float)(1.0 / (double)Lpc.FAST_HYPOT(a, imag));
        }
    }
}

