/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.ApplicationSettings;
import com.neutronio.astrax.app.RepositoryFactory;
import com.neutronio.astrax.app.datapack.DataPackFactory;
import com.neutronio.astrax.app.datapack.DataPackSettings;
import com.neutronio.astrax.app.datapack.RepositoryLoaderSettings;
import com.neutronio.astrax.app.repository.DressupSettingsRepository;
import com.neutronio.astrax.app.repository.UserProfileRepository;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.io.json.config.JSONToButtonSounds;
import com.neutronio.astrax.io.json.config.JSONToGameSettings;
import com.neutronio.astrax.io.json.config.JSONToSoundSettings;
import com.neutronio.astrax.io.json.config.app.JSONToApplicationSettings;
import com.neutronio.astrax.io.json.config.app.JSONToDataPackSettings;
import com.neutronio.astrax.io.json.config.app.JSONToDressupLayer;
import com.neutronio.astrax.io.json.config.app.JSONToDressupSettings;
import com.neutronio.astrax.io.json.config.app.JSONToDressupSettingsRepository;
import com.neutronio.astrax.io.json.config.app.JSONToGeneralSettings;
import com.neutronio.astrax.io.json.config.app.JSONToKeyMappingSettings;
import com.neutronio.astrax.io.json.config.app.JSONToRepositoryLoaderSettings;
import com.neutronio.astrax.io.json.config.app.JSONToSavedGame;
import com.neutronio.astrax.io.json.config.app.JSONToSkinSettings;
import com.neutronio.astrax.io.json.config.app.JSONToUserProfile;
import com.neutronio.astrax.io.json.config.app.JSONToUserProfileRepository;
import com.neutronio.astrax.io.json.config.app.JSONToVideoSettings;
import java.io.IOException;

public class ApplicationConfigurationHandler {
    AstraXApp game;
    DataPackSettings coreDataPackSettings;

    public ApplicationConfigurationHandler(AstraXApp game) {
        this.game = game;
    }

    public void loadApplicationConfig() {
        RepositoryLoaderSettings appRepositoryConfig = new RepositoryLoaderSettings();
        appRepositoryConfig.addConverter(JSONToKeyMappingSettings.class);
        appRepositoryConfig.addConverter(JSONToButtonSounds.class);
        appRepositoryConfig.addConverter(JSONToSoundSettings.class);
        appRepositoryConfig.addConverter(JSONToRepositoryLoaderSettings.class);
        appRepositoryConfig.addConverter(JSONToGeneralSettings.class);
        appRepositoryConfig.addConverter(JSONToVideoSettings.class);
        appRepositoryConfig.addConverter(JSONToSkinSettings.class);
        appRepositoryConfig.addConverter(JSONToApplicationSettings.class);
        appRepositoryConfig.addConverter(JSONToDataPackSettings.class);
        appRepositoryConfig.addConverter(JSONToGameSettings.class);
        appRepositoryConfig.addConverter(JSONToSavedGame.class);
        appRepositoryConfig.addConverter(JSONToDressupLayer.class);
        appRepositoryConfig.addConverter(JSONToDressupSettings.class);
        appRepositoryConfig.addConverter(JSONToDressupSettingsRepository.class);
        appRepositoryConfig.addConverter(JSONToUserProfile.class);
        appRepositoryConfig.addConverter(JSONToUserProfileRepository.class);
        appRepositoryConfig.addRepository("userdata/users.json", UserProfileRepository.class, JSONToUserProfileRepository.class);
        appRepositoryConfig.addRepository("userdata/avatars.json", DressupSettingsRepository.class, JSONToDressupSettingsRepository.class);
        RepositoryFactory repositoryFactory = this.game.getRepositoryFactory();
        repositoryFactory.loadConfiguration(appRepositoryConfig);
        try {
            StringBuilder fileContents = this.game.javaFileHandler.readFileContents("config.json", FileHandler.FileLocation.LOCAL);
            this.game.applicationSettings = repositoryFactory.getDataManager().load(ApplicationSettings.class, fileContents.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadCoreDataPackSettings() {
        RepositoryFactory repositoryFactory = this.game.getRepositoryFactory();
        String dataPackPath = this.game.applicationSettings.startupDataPackPath;
        StringBuilder fileContents = null;
        try {
            fileContents = this.game.javaFileHandler.readFileContents(dataPackPath, this.game.applicationSettings.startupDataPackLocation);
            this.coreDataPackSettings = repositoryFactory.getDataManager().load(DataPackSettings.class, fileContents.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadCoreDataPack() {
        DataPackFactory dataPackFactory = this.game.getAppFactoryByClass(DataPackFactory.class);
        this.game.coreDataPack = dataPackFactory.create(this.coreDataPackSettings);
    }
}

