/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.ApplicationConfigurationHandler;
import com.neutronio.astrax.app.AbstractApplicationFactory;
import com.neutronio.astrax.app.ApplicationSettings;
import com.neutronio.astrax.app.Factory;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.app.RepositoryFactory;
import com.neutronio.astrax.app.UserProfile;
import com.neutronio.astrax.app.UserProfileFactory;
import com.neutronio.astrax.app.datapack.DataPack;
import com.neutronio.astrax.app.datapack.DataPackFactory;
import com.neutronio.astrax.app.datapack.UsageStatistics;
import com.neutronio.astrax.app.datapack.game.GameFactory;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.NameSpace;
import com.neutronio.astrax.app.repository.DataRepository;
import com.neutronio.astrax.app.screen.AbstractScreen;
import com.neutronio.astrax.app.screen.CreditsScreen;
import com.neutronio.astrax.app.screen.IntroScreen;
import com.neutronio.astrax.app.screen.LoadScreen;
import com.neutronio.astrax.app.screen.MainMenuScreen;
import com.neutronio.astrax.app.screen.ScreenFactory;
import com.neutronio.astrax.app.screen.SpaceScreen;
import com.neutronio.astrax.app.screen.SpacecraftEditorScreen;
import com.neutronio.astrax.app.screen.test.AsteroidGraphicsTest;
import com.neutronio.astrax.app.screen.test.BackgroundPanelTest;
import com.neutronio.astrax.app.screen.test.CentralHUDTest;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.app.screen.test.DockingTest;
import com.neutronio.astrax.app.screen.test.FileDialogTest;
import com.neutronio.astrax.app.screen.test.FormContainerTest;
import com.neutronio.astrax.app.screen.test.GalaxyBackgroundTest;
import com.neutronio.astrax.app.screen.test.GalaxyRegionTest;
import com.neutronio.astrax.app.screen.test.GaugeTest;
import com.neutronio.astrax.app.screen.test.GraphicsContainerTest;
import com.neutronio.astrax.app.screen.test.InteractiveGalaxyMapTest;
import com.neutronio.astrax.app.screen.test.InventoryPanelTest;
import com.neutronio.astrax.app.screen.test.MerchantTest;
import com.neutronio.astrax.app.screen.test.ParticleTest;
import com.neutronio.astrax.app.screen.test.PhysicsTest;
import com.neutronio.astrax.app.screen.test.PlanetGeneratorTest;
import com.neutronio.astrax.app.screen.test.PlanetGraphicsTest;
import com.neutronio.astrax.app.screen.test.SavedSatelliteTest;
import com.neutronio.astrax.app.screen.test.SavingTest;
import com.neutronio.astrax.app.screen.test.SelectBoxTest;
import com.neutronio.astrax.app.screen.test.SensorTest;
import com.neutronio.astrax.app.screen.test.ShipEditorTest;
import com.neutronio.astrax.app.screen.test.SpatialSoundTest;
import com.neutronio.astrax.app.screen.test.StarMapTest;
import com.neutronio.astrax.app.screen.test.UIComponentsTest;
import com.neutronio.astrax.app.screen.test.UserAvatarTest;
import com.neutronio.astrax.input.ReactiveCursor;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.io.JavaFileHandler;
import com.neutronio.astrax.io.json.config.app.JSONToApplicationSettings;
import com.neutronio.astrax.sfx.MusicPlayer;
import com.neutronio.astrax.sfx.SoundLoader;
import com.neutronio.astrax.sfx.SoundManager;
import com.neutronio.astrax.sfx.SpatialSoundManager;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.widgets.AlertStack;
import com.neutronio.astrax.ui.commons.widgets.MessageBox;
import com.neutronio.astrax.ui.commons.widgets.Modal;
import com.neutronio.astrax.ui.commons.widgets.dialog.DialogBox;
import com.neutronio.astrax.util.AstraXUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.json.JSONObject;

public class AstraXApp
extends Game {
    public static String DEFAULT_DATAPACK = "astrax-core";
    public static String VERSION = "n.a.";
    public static AstraXApp astraX;
    protected Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    protected ApplicationSettings applicationSettings;
    protected ApplicationConfigurationHandler applicationConfigurationHandler;
    protected UserProfile activeUserProfile;
    protected AstraXFiles astraXFiles = new AstraXFiles();
    protected JavaFileHandler javaFileHandler = new JavaFileHandler();
    protected SoundLoader soundLoader;
    protected SoundManager uiSoundManager;
    protected SpatialSoundManager sfxSoundManager;
    protected MusicPlayer musicPlayer;
    protected DataPack coreDataPack = null;
    protected Class<? extends AbstractScreen> entryScreen;
    protected Map<Class<? extends AbstractScreen>, AbstractScreen> screens = new LinkedHashMap<Class<? extends AbstractScreen>, AbstractScreen>();
    public InputMultiplexer inputMultiplexer;
    protected List<DevScreenBase> devScreens = new ArrayList<DevScreenBase>();
    protected List<Class<? extends DevScreenBase>> devScreenClasses = new ArrayList<Class<? extends DevScreenBase>>();
    protected ComponentFactory componentFactory;
    protected RepositoryFactory repositoryFactory;
    protected ReactiveCursor reactiveCursor;
    protected Label versionLabel;
    protected Label fpsLabel;
    protected Stage gameStage;
    protected AlertStack alerts;
    protected MessageBox messageBox;
    protected Modal<MessageBox> messageBoxModal;
    protected DialogBox dialogBox;
    protected Modal<DialogBox> dialogBoxModal;

    public AstraXApp() {
        astraX = this;
        this.soundLoader = new SoundLoader(this);
        this.sfxSoundManager = new SpatialSoundManager("sfx");
        this.uiSoundManager = new SoundManager("ui");
    }

    @Override
    public void create() {
        this.applicationConfigurationHandler.loadCoreDataPack();
        this.reactiveCursor = new ReactiveCursor();
        this.reactiveCursor.resetCursor();
        this.devScreenClasses.add(AsteroidGraphicsTest.class);
        this.devScreenClasses.add(CentralHUDTest.class);
        this.devScreenClasses.add(BackgroundPanelTest.class);
        this.devScreenClasses.add(DockingTest.class);
        this.devScreenClasses.add(FileDialogTest.class);
        this.devScreenClasses.add(FormContainerTest.class);
        this.devScreenClasses.add(GalaxyBackgroundTest.class);
        this.devScreenClasses.add(GalaxyRegionTest.class);
        this.devScreenClasses.add(GaugeTest.class);
        this.devScreenClasses.add(GraphicsContainerTest.class);
        this.devScreenClasses.add(InteractiveGalaxyMapTest.class);
        this.devScreenClasses.add(InventoryPanelTest.class);
        this.devScreenClasses.add(ParticleTest.class);
        this.devScreenClasses.add(PhysicsTest.class);
        this.devScreenClasses.add(PlanetGeneratorTest.class);
        this.devScreenClasses.add(PlanetGraphicsTest.class);
        this.devScreenClasses.add(UIComponentsTest.class);
        this.devScreenClasses.add(SavedSatelliteTest.class);
        this.devScreenClasses.add(SavingTest.class);
        this.devScreenClasses.add(ShipEditorTest.class);
        this.devScreenClasses.add(SpatialSoundTest.class);
        this.devScreenClasses.add(SensorTest.class);
        this.devScreenClasses.add(SelectBoxTest.class);
        this.devScreenClasses.add(StarMapTest.class);
        this.devScreenClasses.add(MerchantTest.class);
        this.devScreenClasses.add(UserAvatarTest.class);
        this.componentFactory = this.getAppFactoryByClass(ComponentFactory.class);
        this.componentFactory.loadSkin(this.applicationSettings.skinSettings);
        this.componentFactory.loadTranslations(this.applicationSettings.skinSettings);
        String gameVersion = "AstraX " + VERSION;
        this.gameStage = new Stage();
        this.versionLabel = new Label(gameVersion, this.componentFactory.getSkin(), "small-no-bg");
        this.versionLabel.setPosition((float)Gdx.graphics.getWidth() - this.versionLabel.getWidth() - 10.0f, (float)Gdx.graphics.getHeight() - this.versionLabel.getHeight() - 5.0f);
        this.versionLabel.setTouchable(Touchable.disabled);
        this.fpsLabel = new Label("", this.componentFactory.getSkin(), "small-no-bg");
        this.fpsLabel.setPosition(20.0f, 20.0f);
        this.fpsLabel.setTouchable(Touchable.disabled);
        this.alerts = new AlertStack(this.componentFactory, "application", 5);
        this.alerts.setShowDuration(8.0f);
        this.alerts.setWidth(250.0f);
        this.alerts.align(1);
        this.alerts.pack();
        this.messageBox = new MessageBox(this.componentFactory);
        this.messageBox.construct();
        this.messageBoxModal = new Modal<MessageBox>(this.componentFactory, this.messageBox);
        this.messageBoxModal.setHeaderIcon("icon_inline_info");
        this.messageBoxModal.setHeaderText("Info");
        this.messageBoxModal.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                AstraXApp.this.messageBoxModal.hide();
            }
        });
        this.dialogBox = new DialogBox(this.componentFactory);
        this.dialogBox.construct();
        this.dialogBox.addListener(new DialogBox.DialogBoxListener(){

            @Override
            public void onProceed() {
                AstraXApp.this.dialogBoxModal.hide();
            }

            @Override
            public void onCancel() {
                AstraXApp.this.dialogBoxModal.hide();
            }
        });
        this.dialogBoxModal = new Modal<DialogBox>(this.componentFactory, this.dialogBox);
        this.dialogBoxModal.setHeaderIcon("icon_inline_questionmark");
        this.dialogBoxModal.setHeaderText("Warning");
        this.gameStage.addActor(this.versionLabel);
        this.gameStage.addActor(this.fpsLabel);
        this.gameStage.addActor(this.alerts);
        this.gameStage.addActor(this.messageBoxModal);
        this.gameStage.addActor(this.dialogBoxModal);
        this.inputMultiplexer = new InputMultiplexer();
        this.inputMultiplexer.addProcessor(this.gameStage);
        Gdx.input.setInputProcessor(this.inputMultiplexer);
        this.musicPlayer = new MusicPlayer();
        SpaceScreen mainGame = new SpaceScreen(this);
        this.instantiateDevScreens();
        this.addScreen(new SpacecraftEditorScreen(this));
        this.addScreen(new MainMenuScreen(this));
        this.addScreen(new IntroScreen(this));
        this.addScreen(new LoadScreen(this));
        this.addScreen(new CreditsScreen(this));
        this.addScreen(mainGame);
        this.applyGameSettings(this.applicationSettings);
        this.setScreen(this.entryScreen);
        this.musicPlayer.play();
    }

    public void initJSONRepository() {
        this.repositoryFactory = new RepositoryFactory(this);
        this.componentFactory = new ComponentFactory(this);
        GameFactory gameFactory = new GameFactory(this);
        ScreenFactory screenFactory = new ScreenFactory(this, gameFactory);
        DataPackFactory dataPackFactory = new DataPackFactory(this);
        UserProfileFactory userProfileFactory = new UserProfileFactory();
        this.registerApplicationFactory(this.componentFactory);
        this.registerApplicationFactory(gameFactory);
        this.registerApplicationFactory(screenFactory);
        this.registerApplicationFactory(dataPackFactory);
        this.registerApplicationFactory(userProfileFactory);
        this.loadApplicationSettings();
    }

    public void saveApplicationData(ApplicationSettings applicationSettings) {
        this.logger.info("Saving ApplicationSettings...");
        Message message = new Message();
        JSONToApplicationSettings applicationSettingsConverter = astraX.getRepositoryFactory().getDataManager().getConverter(JSONToApplicationSettings.class);
        JSONObject appSettingJson = applicationSettingsConverter.convertToJSON(applicationSettings);
        try {
            FileHandler.State state = astraX.getAstraXFiles().saveFileContents(appSettingJson.toString(4), "config.json", FileHandler.FileLocation.LOCAL, true);
            String translate = this.componentFactory.translate(state.message, "config.json");
            message.setType(state.messageType);
            message.setMessage(translate);
        }
        catch (IOException e) {
            e.printStackTrace();
            message.setMessage(this.componentFactory.translate("menu_message_appsettings_error") + "\n" + this.componentFactory.translate("app_check_log"));
        }
        this.showMessageAlert(message);
    }

    public Stage getGameStage() {
        return this.gameStage;
    }

    public UserProfile getActiveUserProfile() {
        return this.activeUserProfile;
    }

    public void setActiveUserProfile(UserProfile activeUserProfile) {
        this.activeUserProfile = activeUserProfile;
    }

    public void showMessageBox(String message, String icon) {
        this.messageBox.setText(message);
        this.messageBox.setIcon(icon);
        this.messageBox.construct();
        this.messageBoxModal.pack();
        this.messageBoxModal.show();
    }

    public void showDialogBox(String message, DialogBox.DialogBoxListener callback) {
        this.dialogBox.setCallback(callback);
        this.dialogBox.setText(message);
        this.dialogBox.setIcon(null);
        this.dialogBox.construct();
        this.dialogBoxModal.show();
    }

    public void showDialogBox(Message message, DialogBox.DialogBoxListener callback) {
        this.dialogBox.setCallback(callback);
        this.dialogBox.setText(message.getMessage());
        this.dialogBoxModal.setHeaderIcon("icon_inline_" + message.getType().toIconLabelStyle());
        this.dialogBoxModal.show();
    }

    public void showMessageAlert(Message ... messages) {
        for (Message msg : messages) {
            this.alerts.showMessage(msg);
        }
        this.uiSoundManager.playSoundOnce(messages[0].getType().getSound());
    }

    public void showSuccessAlert(String ... message) {
        for (String msg : message) {
            this.alerts.showSuccessGrowl(msg);
        }
        this.uiSoundManager.playSoundOnce(Message.MessageType.SUCCESS.getSound());
    }

    public void showInfoAlert(String ... message) {
        for (String msg : message) {
            this.alerts.showInfoGrowl(msg);
        }
        this.uiSoundManager.playSoundOnce(Message.MessageType.INFO.getSound());
    }

    public void showInfoAlert(String customSound, String message) {
        this.alerts.showInfoGrowl(message);
        this.uiSoundManager.playSoundOnce(customSound);
    }

    public void showWarningAlert(String ... message) {
        for (String msg : message) {
            this.alerts.showWarningGrowl(msg);
        }
        this.uiSoundManager.playSoundOnce(Message.MessageType.WARNING.getSound());
    }

    public void showErrorAlert(String ... message) {
        for (String msg : message) {
            this.alerts.showErrorGrowl(msg);
        }
        this.uiSoundManager.playSoundOnce(Message.MessageType.EXCEPTION.getSound());
    }

    public void showErrorAlert(List<ValidationResult.ValidationMessage> messages) {
        for (ValidationResult.ValidationMessage msg : messages) {
            this.alerts.showErrorGrowl(msg.message);
        }
        this.uiSoundManager.playSoundOnce(Message.MessageType.EXCEPTION.getSound());
    }

    public void showValidationMessages(ValidationResult validationResult) {
        switch (validationResult.getStatus()) {
            case VALID: {
                for (ValidationResult.ValidationMessage msg : validationResult.getMessages()) {
                    this.alerts.showSuccessGrowl(msg.message);
                }
                this.uiSoundManager.playSoundOnce(Message.MessageType.SUCCESS.getSound());
                break;
            }
            case INVALID: {
                for (ValidationResult.ValidationMessage msg : validationResult.getMessages()) {
                    this.alerts.showErrorGrowl(msg.message);
                }
                this.uiSoundManager.playSoundOnce(Message.MessageType.EXCEPTION.getSound());
            }
        }
    }

    public ComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    public RepositoryFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public <T extends AbstractFactory> T getFactoryByClass(Class<T> clazz) {
        return (T)((AbstractFactory)this.repositoryFactory.getDataManager().getFactory(clazz));
    }

    public <T extends AbstractApplicationFactory> T getAppFactoryByClass(Class<T> clazz) {
        return (T)((AbstractApplicationFactory)this.repositoryFactory.getDataManager().getFactory(clazz));
    }

    public Collection<Factory> getAllLoadedFactories() {
        return this.repositoryFactory.getDataManager().getAllLoadedFactories();
    }

    public Factory getFactoryByNameSpace(NameSpace nameSpace) {
        return this.repositoryFactory.getDataManager().getFactoryByNameSpace(nameSpace);
    }

    public void registerApplicationFactory(AbstractApplicationFactory factory) {
        this.logger.info("Registering app factory " + factory.getClass());
        this.repositoryFactory.getDataManager().registerFactory(factory);
    }

    public <T extends DataRepository> T getRepository(Class<T> clazz) {
        return this.getRepositoryFactory().getDataManager().getRepository(clazz);
    }

    public <R> R findResource(String id) {
        return (R)this.getRepositoryFactory().findResourceByID(id);
    }

    public UsageStatistics getStatistics() {
        return this.repositoryFactory.getDataManager().getStatistics();
    }

    @Override
    public void render() {
        if (Gdx.input.isKeyJustPressed(142)) {
            this.logger.info("Taking screenshot... ");
            if (this.activeUserProfile != null) {
                FileHandle profileRoot = Gdx.files.local(this.activeUserProfile.resourcePath);
                AstraXUtil.takeScreenshot(profileRoot);
            } else {
                AstraXUtil.takeScreenshot();
            }
            this.showInfoAlert("Screenshot taken!");
        }
        super.render();
        this.alerts.setPosition((float)(Gdx.graphics.getWidth() / 2) - this.alerts.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() - this.alerts.getHeight() - 70.0f);
        this.gameStage.act();
        this.gameStage.draw();
        if (this.fpsLabel.isVisible()) {
            this.fpsLabel.setText(Gdx.graphics.getFramesPerSecond());
        }
    }

    private void instantiateDevScreens() {
        this.logger.info("Instantiate Developer screens...");
        for (Class<? extends DevScreenBase> devScreenClass : this.devScreenClasses) {
            try {
                this.logger.finest("... " + devScreenClass.getCanonicalName());
                Constructor<? extends DevScreenBase> constructor = devScreenClass.getConstructor(AstraXApp.class);
                DevScreenBase devScreen = constructor.newInstance(this);
                this.devScreens.add(devScreen);
                this.addScreen(devScreen);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadApplicationSettings() {
        this.logger.log(Level.INFO, "Loading Application Settings...");
        this.applicationConfigurationHandler = new ApplicationConfigurationHandler(this);
        this.applicationConfigurationHandler.loadApplicationConfig();
        this.logger.log(Level.INFO, "Loading core DataPackSettings from path '" + this.applicationSettings.startupDataPackPath + "'...");
        this.applicationConfigurationHandler.loadCoreDataPackSettings();
    }

    public void setupLogging() {
        block4: {
            FileInputStream fis = null;
            File file = Paths.get("logging.properties", new String[0]).toFile();
            try {
                LogManager logManager = LogManager.getLogManager();
                fis = new FileInputStream(file);
                logManager.readConfiguration(fis);
                fis.close();
                this.logger.log(Level.INFO, "Logging initialized!");
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Could not initialize logging with default config file: " + file.toPath(), e);
                if (fis == null) break block4;
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void readVersion() {
        this.logger.log(Level.INFO, "Reading Version...");
        try {
            byte[] encoded = Files.readAllBytes(Paths.get("version", new String[0]));
            VERSION = new String(encoded, Charset.forName("UTF-8"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void applyGameSettings(ApplicationSettings applicationSettings) {
        this.uiSoundManager.setMaxVolume(applicationSettings.generalSettings.uiVolume);
        this.uiSoundManager.updateVolume();
        this.sfxSoundManager.setMaxVolume(applicationSettings.generalSettings.sfxVolume);
        this.sfxSoundManager.updateVolume();
        this.musicPlayer.setMaxVolume(applicationSettings.generalSettings.musicVolume);
        this.applicationSettings.keyMappingSettings.merge(applicationSettings.keyMappingSettings);
        this.fpsLabel.setVisible(applicationSettings.generalSettings.showFPS);
        this.versionLabel.setVisible(applicationSettings.generalSettings.showVersion);
        SpaceScreen screen = this.getScreen(SpaceScreen.class);
        this.applyKeyMappingsToScreen(screen);
    }

    public void applyKeyMappingsToScreen(SpaceScreen screen) {
        if (screen.getInputProcessor() != null) {
            screen.getInputProcessor().initializeMappings(this.applicationSettings.keyMappingSettings);
        }
    }

    public AstraXFiles getAstraXFiles() {
        return this.astraXFiles;
    }

    public JavaFileHandler getJavaFileHandler() {
        return this.javaFileHandler;
    }

    public ReactiveCursor getReactiveCursor() {
        return this.reactiveCursor;
    }

    public List<DevScreenBase> getDevScreens() {
        return this.devScreens;
    }

    public DataPack getCoreDataPack() {
        return this.coreDataPack;
    }

    public Class<? extends AbstractScreen> getEntryScreen() {
        return this.entryScreen;
    }

    public void setEntryScreen(Class<? extends AbstractScreen> entryScreen) {
        this.entryScreen = entryScreen;
    }

    public SoundLoader getSoundLoader() {
        return this.soundLoader;
    }

    public MusicPlayer getMusicPlayer() {
        return this.musicPlayer;
    }

    @Deprecated
    public ApplicationSettings getGameSettings() {
        return this.applicationSettings;
    }

    public SpatialSoundManager getSfxSoundManager() {
        return this.sfxSoundManager;
    }

    public SoundManager getUiSoundManager() {
        return this.uiSoundManager;
    }

    public ApplicationSettings getApplicationSettings() {
        return this.applicationSettings;
    }

    public void setScreen(Class<? extends AbstractScreen> screenClass) {
        AbstractScreen screen = this.screens.get(screenClass);
        if (screen == null) {
            this.logger.warning("Could not switch screens! Screen not found: " + screenClass.getCanonicalName());
            return;
        }
        AbstractScreen oldScreen = (AbstractScreen)this.getScreen();
        if (oldScreen != null) {
            this.inputMultiplexer.removeProcessor(oldScreen.getHudStage());
        }
        super.setScreen(screen);
        this.inputMultiplexer.addProcessor(screen.getHudStage());
    }

    @Override
    public void setScreen(Screen screen) {
        throw new UnsupportedOperationException("Use setScreen( screenClass ) or setScreen( screenClass, InputProcessor) instead!");
    }

    public <T extends AbstractScreen> T getScreen(Class<T> screenClass) {
        return (T)this.screens.get(screenClass);
    }

    public void addScreen(AbstractScreen screen) {
        this.screens.put(screen.getClass(), screen);
    }

    public void removeScreen(Class<? extends AbstractScreen> screen) {
        this.screens.put(screen, null);
    }

    public InputMultiplexer getInputMultiplexer() {
        return this.inputMultiplexer;
    }

    @Override
    public void dispose() {
        for (Screen screen : this.screens.values()) {
            screen.dispose();
        }
        super.dispose();
    }
}

