/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax;

public class AstraXException
extends RuntimeException {
    private ErrorCode errorCode = ErrorCode.E0000;

    public AstraXException() {
    }

    public AstraXException(ErrorCode errorcode) {
        super(AstraXException.getMessage(errorcode, null));
        this.errorCode = errorcode;
    }

    public AstraXException(ErrorCode errorcode, String comment) {
        super(AstraXException.getMessage(errorcode, comment));
        this.errorCode = errorcode;
    }

    public AstraXException(ErrorCode errorcode, String comment, Throwable cause) {
        super(AstraXException.getMessage(errorcode, comment), cause);
        this.errorCode = errorcode;
    }

    public AstraXException(Throwable cause) {
        super(AstraXException.getMessage(ErrorCode.E0000, null), cause);
    }

    public AstraXException(ErrorCode errorcode, Throwable cause) {
        super(AstraXException.getMessage(errorcode, null), cause);
    }

    private static String getMessage(ErrorCode errorcode, String comment) {
        return "[" + errorcode.name() + "] " + errorcode.message + (comment != null ? ": " + comment : "");
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public static enum ErrorCode {
        E0000("Error not specified"),
        E0001("Initialization Error"),
        E0002("Class Configuration missing"),
        E0003("Validation error"),
        E0004("Illegal Argument(s)"),
        E1000("File not found"),
        E1010("Could not open file"),
        E1011("File already in use"),
        E1012("No read-access to file"),
        E2000("Could not read Object"),
        E2001("Could not write Object"),
        E2002("Version mismatch"),
        E2003("Instantiation error"),
        E2004("Class not found"),
        E2005("Missing field in file"),
        E2010("Could not parse contents. Error in data structure"),
        E3000("Could not find ID"),
        E3001("Registered Entity not found"),
        E3002("Duplicate ID, only one allowed"),
        E3100("Datapack not found"),
        E3110("Texture not found"),
        E3111("TextureRegions not found"),
        E3102("Could not find expected field"),
        E3103("API Mismatch: provided data does not match expected API"),
        E3104("Type mismatch: provided data does not match expected data"),
        E4001("Probability set returned no results"),
        E4002("Obtaining object by tags returned no results");

        private String message = "-";

        private ErrorCode(String message) {
            this.message = message;
        }
    }
}

