/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.decals.CameraGroupStrategy;
import com.badlogic.gdx.graphics.g3d.decals.Decal;
import com.badlogic.gdx.graphics.g3d.decals.DecalBatch;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.utils.CameraInputController;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import java.util.ArrayList;
import java.util.List;

public class Astrax3DGame
extends ApplicationAdapter {
    public Environment environment;
    public PerspectiveCamera cam;
    public Model model;
    public Model modelReference;
    public List<ModelInstance> models = new ArrayList<ModelInstance>();
    public ModelBatch modelBatch;
    public CameraInputController camController;
    public AssetManager assets;
    TextureAtlas atlas;
    Decal decal;
    DecalBatch decalBatch;
    boolean loading = true;

    @Override
    public void create() {
        this.cam = new PerspectiveCamera(80.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.cam.near = 1.0f;
        this.cam.far = 400.0f;
        this.cam.position.set(0.0f, 0.0f, 5.0f);
        this.cam.lookAt(0.0f, 0.0f, 0.0f);
        this.camController = new CameraInputController(this.cam);
        Gdx.input.setInputProcessor(this.camController);
        this.assets = new AssetManager();
        this.modelBatch = new ModelBatch();
        this.decalBatch = new DecalBatch(1000, new CameraGroupStrategy(this.cam));
        ModelBuilder modelBuilder = new ModelBuilder();
        this.modelReference = modelBuilder.createSphere(5.0f, 5.0f, 5.0f, 8, 20, new Material(), 25L);
        ModelInstance reference = new ModelInstance(this.modelReference, 0.0f, 0.0f, 0.0f);
        this.models.add(reference);
        this.environment = new Environment();
        this.environment.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, 0.4f, 0.4f, 0.4f, 1.0f));
        this.environment.add(new DirectionalLight().set(0.8f, 0.8f, 0.8f, -1.0f, -0.8f, -0.2f));
        this.assets.load("uvmesh.g3db", Model.class);
        this.assets.load("gfx/ship/ship.png", Texture.class);
        this.assets.load("gfx/image_atlas.atlas", TextureAtlas.class);
    }

    private void doneLoading() {
        this.loading = false;
        this.assets.finishLoading();
        this.atlas = this.assets.get("gfx/image_atlas.atlas", TextureAtlas.class);
        this.model = this.assets.get("uvmesh.g3db", Model.class);
        TextureAtlas.AtlasRegion region = this.atlas.findRegion("ship/ship");
        this.decal = Decal.newDecal(region);
        this.decal.setBlending(770, 771);
        this.decal.setPosition(0.0f, 10.0f, 10.0f);
        this.decal.setScale(0.5f, 0.5f);
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
    }

    @Override
    public void render() {
        if (this.loading && this.assets.update()) {
            this.doneLoading();
        }
        Gdx.gl.glViewport(0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        Gdx.gl.glClearColor(0.1f, 0.1f, 0.1f, 1.0f);
        Gdx.gl.glClear(16640);
        this.cam.update();
        this.camController.update();
        if (!this.loading) {
            this.modelBatch.begin(this.cam);
            for (ModelInstance instance : this.models) {
                this.modelBatch.render((RenderableProvider)instance, this.environment);
            }
            this.modelBatch.end();
            Gdx.gl20.glDepthMask(false);
            this.decalBatch.add(this.decal);
            this.decalBatch.flush();
            Gdx.gl20.glDepthMask(true);
        }
    }

    @Override
    public void pause() {
        super.pause();
    }

    @Override
    public void resume() {
        super.resume();
    }

    @Override
    public void dispose() {
        this.modelBatch.dispose();
        this.model.dispose();
    }
}

