/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.BeltTarget;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.screen.SpaceScreen;
import com.neutronio.astrax.gfx.PanningCamera;
import java.util.Objects;

public class CameraFocusManager
extends ClickListener {
    private SpaceScreen spaceScreen;
    private String changeFocusSound = "zoom:in";
    private SatelliteTarget controlledSatellite;
    private PanningCamera camera;

    public CameraFocusManager(SpaceScreen spaceScreen) {
        this.spaceScreen = spaceScreen;
    }

    public void setChangeFocusSound(String changeFocusSound) {
        this.changeFocusSound = changeFocusSound;
    }

    public void setControlledSatellite(SatelliteTarget controlledSatellite) {
        this.controlledSatellite = controlledSatellite;
    }

    public void setCamera(PanningCamera camera) {
        this.camera = camera;
    }

    public void registerTargets(StarSystem starSystem) {
        for (Targetable targetable : starSystem.getSystemMembers()) {
            if (Objects.equals(starSystem.getSun().getID(), targetable.getID()) || targetable instanceof BeltTarget) continue;
            ((Actor)targetable.getGraphics()).addListener(this);
        }
    }

    @Override
    public void clicked(InputEvent event, float x, float y) {
        super.clicked(event, x, y);
        Targetable targetable = (Targetable)event.getListenerActor().getUserObject();
        if (((Satellite)this.controlledSatellite.getModel()).isInSensorRange(targetable) && !Objects.equals(this.camera.getFocusedActor().getID(), targetable.getID()) && !this.spaceScreen.isPaused() && !this.spaceScreen.getTabMenu().isVisible()) {
            this.camera.setFocusedActor(targetable);
            if (Objects.equals(targetable.getID(), this.spaceScreen.getAstraxGame().getLocalPlayer().getPlayerTarget().getID())) {
                this.spaceScreen.getHudComponent().getHudActionPanel().getResetCameraButton().setDisabled(true);
            } else {
                this.spaceScreen.getHudComponent().getHudActionPanel().getResetCameraButton().setDisabled(false);
                this.spaceScreen.getHudComponent().getHudActionPanel().getResetCameraButton().doSquish(1.0f, false);
            }
            AstraXApp.astraX.getUiSoundManager().playSoundOnce(this.changeFocusSound);
        }
        event.stop();
    }

    public void resetFocus() {
        this.camera.setFocusedActor(this.controlledSatellite);
        this.spaceScreen.getHudComponent().getHudActionPanel().getResetCameraButton().setDisabled(true);
        AstraXApp.astraX.getUiSoundManager().playSoundOnce(this.changeFocusSound);
    }
}

