/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app;

import com.badlogic.gdx.Input;
import com.neutronio.astrax.app.CreationSettings;
import com.neutronio.astrax.input.DeviceType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class KeyMappingSettings
implements CreationSettings {
    private Map<String, KeyMapping> keyMappings = new LinkedHashMap<String, KeyMapping>();

    public static String resolveKeyMappingName(DeviceType type, int code) {
        return DeviceType.getInputName(type, code);
    }

    public static String resolveKeyMappingName(KeyMapping keyMapping) {
        return KeyMappingSettings.resolveKeyMappingName(keyMapping.device, keyMapping.code);
    }

    public KeyMappingSettings copy() {
        KeyMappingSettings copy = new KeyMappingSettings();
        for (Map.Entry<String, KeyMapping> mappings : this.keyMappings.entrySet()) {
            copy.addMapping(mappings.getValue().device, mappings.getValue().type, mappings.getValue().code, mappings.getValue().actionName);
        }
        return copy;
    }

    public KeyMapping getMapping(String actionName) {
        return this.keyMappings.get(actionName);
    }

    public Collection<KeyMapping> getMappings() {
        return this.keyMappings.values();
    }

    public void addMapping(DeviceType device, InputType inputType, int code, String actionName) {
        this.keyMappings.put(actionName, new KeyMapping(device, inputType, code, actionName));
    }

    public void merge(KeyMappingSettings settings) {
        for (KeyMapping mapping : settings.getMappings()) {
            KeyMapping baseMapping = this.keyMappings.get(mapping.actionName);
            if (baseMapping != null) {
                baseMapping.device = mapping.device == null ? baseMapping.device : mapping.device;
                baseMapping.type = mapping.type == null ? baseMapping.type : mapping.type;
                baseMapping.code = mapping.code;
                baseMapping.name = Input.Keys.toString(mapping.code);
                continue;
            }
            this.addMapping(mapping.device, mapping.type, mapping.code, mapping.actionName);
        }
    }

    public static class KeyMapping {
        public InputType type;
        public DeviceType device;
        public int code = -1;
        public String name;
        public String actionName;

        @Deprecated
        protected KeyMapping(int code, String name, String actionName) {
            this.code = code;
            this.actionName = actionName;
            this.name = name;
        }

        @Deprecated
        protected KeyMapping(InputType type, int code, String name, String actionName) {
            this.type = type;
            this.code = code;
            this.actionName = actionName;
            this.name = name;
        }

        protected KeyMapping(DeviceType device, InputType inputType, int code, String actionName) {
            this.device = device;
            this.type = inputType;
            this.code = code;
            this.actionName = actionName;
            this.name = DeviceType.getInputName(device, code);
        }
    }

    public static enum InputType {
        KEY,
        KEY_CONTINUOUS,
        MOUSE,
        MOUSE_SCROLL,
        GAMEPAD,
        TYPED,
        HOLD,
        SCROLL,
        XAXIS,
        YAXIS;

    }
}

