/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;

public class Message
implements Serializable {
    private Date timestamp;
    private MessageType type;
    private String message;
    private String voiceMessage;

    public Message() {
        this.timestamp = new Date();
    }

    public Message(Date timestamp, MessageType type, String message) {
        this.timestamp = timestamp;
        this.type = type;
        this.message = message;
    }

    public Message(MessageType type, String message) {
        this.timestamp = new Date();
        this.type = type;
        this.message = message;
    }

    public Message(MessageType type, String message, String voiceMessage) {
        this.timestamp = new Date();
        this.type = type;
        this.message = message;
        this.voiceMessage = voiceMessage;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public MessageType getType() {
        return this.type;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getVoiceMessage() {
        return this.voiceMessage;
    }

    public void setVoiceMessage(String voiceMessage) {
        this.voiceMessage = voiceMessage;
    }

    public static enum MessageType {
        SUCCESS("notification_success", "beep1"),
        INFO("notification_info", "chime"),
        WARNING("notification_warning", "warning"),
        ALERT("notification_critical", "alert"),
        EXCEPTION("notification_critical", "error");

        private String style;
        private String sound;

        private MessageType(String style, String uisound) {
            this.sound = uisound;
            this.style = style;
        }

        public String getSound() {
            return this.sound;
        }

        public String getStyle() {
            return this.style;
        }

        public String toLabelStyle() {
            switch (this) {
                case INFO: {
                    return "label-transparent";
                }
                case SUCCESS: {
                    return "label-success";
                }
                case WARNING: {
                    return "label-warning";
                }
                case ALERT: {
                    return "label-error";
                }
                case EXCEPTION: {
                    return "label-error";
                }
            }
            return "label-transparent";
        }

        public String toIconLabelStyle() {
            switch (this) {
                case SUCCESS: {
                    return "success";
                }
                case INFO: {
                    return "info";
                }
                case WARNING: {
                    return "warning";
                }
                case ALERT: 
                case EXCEPTION: {
                    return "error";
                }
            }
            return "info";
        }
    }

    public static class MessageComparator
    implements Comparator<Message> {
        @Override
        public int compare(Message o1, Message o2) {
            return Integer.compare(o1.getType().ordinal(), o2.getType().ordinal());
        }
    }
}

