/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.AbstractApplicationFactory;
import com.neutronio.astrax.app.datapack.DataRepositorySetting;
import com.neutronio.astrax.app.datapack.RepositoryLoaderSettings;
import com.neutronio.astrax.app.datapack.TranslationSettings;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.app.repository.DataRepository;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.io.json.JSONConverter;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.JSONRepositoryConverter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.json.JSONObject;

public class RepositoryFactory
extends AbstractApplicationFactory
implements GenericFactory<DataRepository, DataRepositorySetting> {
    protected FileHandler fileHandler;
    protected DataManager dataManager = new DataManager();

    public RepositoryFactory(AstraXApp game) {
        super(game);
        this.fileHandler = game.getAstraXFiles();
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public <T> List<T> findResourcesByIDs(List<String> ids) {
        return this.dataManager.findDataByIDs(ids);
    }

    public <T> T findResourceByID(String id) {
        return this.dataManager.findDataByID(id);
    }

    public Object findResourceByID(Enum<?> enumID) {
        return this.findResourceByID(enumID.name());
    }

    @Override
    public DataRepository create(DataRepositorySetting repositorySetting) {
        try {
            return this.load(null, repositorySetting);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void loadConfiguration(RepositoryLoaderSettings loaderSettings) {
        this.logger.info("Loading data from " + loaderSettings.getRootPath());
        this.dataManager.addConfiguration(loaderSettings);
        this.dataManager.instantiateConverters(loaderSettings);
        for (TranslationSettings translations : loaderSettings.getTranslations().values()) {
            this.dataManager.loadTranslations(translations, FileHandler.FileLocation.INTERNAL, loaderSettings.getRootPath(), AstraXApp.astraX.getApplicationSettings().skinSettings.language);
        }
        for (DataRepositorySetting setting : loaderSettings.getRepositorySettings()) {
            try {
                DataRepository loadedRepository = this.load(loaderSettings.getRootPath(), setting);
                this.dataManager.registerDataRepository(loadedRepository, setting);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.dataManager.instantiateFactories(loaderSettings);
    }

    public DataRepository load(String rootPath, DataRepositorySetting repositorySetting) throws IOException {
        this.logger.fine("Loading " + repositorySetting.getPath() + " from file...");
        if (repositorySetting.loaded) {
            throw new AstraXException(AstraXException.ErrorCode.E0001, repositorySetting.path);
        }
        String fromPath = rootPath != null ? rootPath + repositorySetting.getPath() : repositorySetting.getPath();
        JSONRepositoryConverter converter = this.dataManager.getConverter(repositorySetting.repositoryConverterClass);
        StringBuilder builder = this.fileHandler.readFileContents(fromPath, FileHandler.FileLocation.LOCAL);
        JSONObject spacecraftFile = new JSONObject(builder.toString());
        DataRepository loadedObject = (DataRepository)converter.convert(spacecraftFile.toString());
        repositorySetting.loaded = true;
        return loadedObject;
    }

    public <T> T load(String rootPath, JSONConverter converter) throws IOException {
        this.logger.fine("Loading " + rootPath + " from file...");
        StringBuilder builder = this.fileHandler.readFileContents(rootPath, FileHandler.FileLocation.LOCAL);
        JSONObject spacecraftFile = new JSONObject(builder.toString());
        Object loadedObject = converter.convert(spacecraftFile);
        return loadedObject;
    }

    public FileHandler.State save(DataRepository object, String basePath, String filename, boolean overwrite) {
        this.logger.log(Level.INFO, "Saving to {0}/{1}", new Object[]{basePath, filename});
        Object message = null;
        DataRepositorySetting setting = this.dataManager.findRepositorySettingOf(object.getClass());
        JSONRepositoryConverter converter = this.dataManager.getConverter(setting.repositoryConverterClass);
        try {
            if (!filename.endsWith(".json")) {
                filename = filename + ".json";
            }
            String fullPath = basePath + "/" + filename;
            JSONObject value = converter.convertToJSON(object);
            return this.fileHandler.saveFileContents(value.toString(2), fullPath, FileHandler.FileLocation.LOCAL, overwrite);
        }
        catch (IOException e) {
            e.printStackTrace();
            return FileHandler.State.FAILED;
        }
    }

    public FileHandler.State save(Object object, JSONConverter converter, String basePath, String filename, boolean overwrite) {
        this.logger.log(Level.INFO, "Saving to {0}/{1}", new Object[]{basePath, filename});
        try {
            if (!filename.endsWith(".json")) {
                filename = filename + ".json";
            }
            String fullPath = basePath + "/" + filename;
            JSONObject value = converter.convertToJSON(object);
            return this.fileHandler.saveFileContents(value.toString(2), fullPath, FileHandler.FileLocation.LOCAL, overwrite);
        }
        catch (IOException e) {
            e.printStackTrace();
            return FileHandler.State.FAILED;
        }
    }
}

