/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.app.CreationSettings;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.util.AstraXUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SkinSettings
implements CreationSettings {
    public Locale language = Locale.ENGLISH;
    public FileHandler.FileLocation skinLocation = FileHandler.FileLocation.INTERNAL;
    public String baseDirectory = "skins/astrax-core-ui/";
    public String soundsFile = "sounds.json";
    public String stylesJsonFile = "styles.json";
    public String stylesAtlasFile = "styles.atlas";
    public String translationsPath = "lang";
    public String translationsBundleName = "astrax";
    public Map<String, Color> uiColors = new HashMap<String, Color>();

    public static Map<String, Color> getDefaultColors() {
        HashMap<String, Color> colors = new HashMap<String, Color>();
        colors.put("primary", Color.valueOf("11c1d0ff"));
        colors.put("primary-dark", AstraXUtil.mult(Color.valueOf("11c1d0ff"), 0.7f));
        colors.put("primary-bright", AstraXUtil.mult(Color.valueOf("11c1d0ff"), 1.3f));
        colors.put("secondary", Color.valueOf("343c42ff"));
        colors.put("secondary-alpha", Color.valueOf("343c4288"));
        colors.put("secondary-dark", AstraXUtil.mult(Color.valueOf("343c42ff"), 0.7f));
        colors.put("secondary-bright", AstraXUtil.mult(Color.valueOf("343c42ff"), 1.3f));
        colors.put("tertiary", Color.valueOf("891156ff"));
        colors.put("tertiary-dark", AstraXUtil.mult(Color.valueOf("891156ff"), 0.7f));
        colors.put("tertiary-bright", AstraXUtil.mult(Color.valueOf("891156ff"), 1.3f));
        return colors;
    }

    public static SkinSettings getDefaultSkinSettings() {
        SkinSettings settings = new SkinSettings();
        settings.language = Locale.ENGLISH;
        settings.skinLocation = FileHandler.FileLocation.INTERNAL;
        settings.baseDirectory = "skins/astrax-core-ui/";
        settings.soundsFile = "sounds.json";
        settings.stylesJsonFile = "styles.json";
        settings.stylesAtlasFile = "styles.atlas";
        settings.translationsPath = "lang";
        settings.translationsBundleName = "astrax";
        settings.uiColors = SkinSettings.getDefaultColors();
        return settings;
    }

    public SkinSettings copy() {
        SkinSettings settings = new SkinSettings();
        settings.skinLocation = FileHandler.FileLocation.INTERNAL;
        settings.baseDirectory = this.baseDirectory;
        settings.soundsFile = this.soundsFile;
        settings.stylesJsonFile = this.stylesJsonFile;
        settings.stylesAtlasFile = this.stylesAtlasFile;
        settings.translationsPath = this.translationsPath;
        settings.translationsBundleName = this.translationsBundleName;
        for (Map.Entry<String, Color> entry : this.uiColors.entrySet()) {
            settings.uiColors.put(entry.getKey(), entry.getValue());
        }
        return settings;
    }
}

