/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app;

import com.neutronio.astrax.app.repository.Tagged;
import com.neutronio.astrax.util.collections.GroupedMap;
import java.util.ArrayList;
import java.util.List;

public class TagManager {
    private GroupedMap<String, Tagged> tags = new GroupedMap();
    private List<Tagged> allTags = new ArrayList<Tagged>();

    public List<Tagged> getAllByTag(String tag) {
        return this.tags.getElements(tag);
    }

    public List<Tagged> getAllByTag(String ... tags) {
        ArrayList<Tagged> result = new ArrayList<Tagged>();
        boolean includeTemp = true;
        for (Tagged tagged : this.allTags) {
            for (String tag : tags) {
                if (tagged.hasTag(tag)) continue;
                includeTemp = false;
            }
            if (includeTemp) {
                result.add(tagged);
            }
            includeTemp = true;
        }
        return result;
    }

    public List<Tagged> getAllByTag(List<String> tags) {
        ArrayList<Tagged> result = new ArrayList<Tagged>();
        boolean includeTemp = true;
        for (Tagged tagged : this.allTags) {
            for (String tag : tags) {
                if (tagged.hasTag(tag)) continue;
                includeTemp = false;
            }
            if (includeTemp) {
                result.add(tagged);
            }
            includeTemp = true;
        }
        return result;
    }

    public List<Tagged> getByTag(List<String> tags, List<String> exclude) {
        List<Tagged> result = this.getAllByTag(tags);
        boolean remove = false;
        for (Tagged tagged : this.allTags) {
            for (String tag : tags) {
                if (tagged.hasTag(tag)) continue;
                remove = true;
                break;
            }
            for (String tag : exclude) {
                if (!tagged.hasTag(tag)) continue;
                remove = true;
                break;
            }
            if (remove) {
                result.remove(tagged);
            }
            remove = false;
        }
        return result;
    }

    public void addTag(Tagged tagged) {
        this.allTags.add(tagged);
        for (String tag : tagged.getTags()) {
            this.tags.addToGroup(tag, tagged);
        }
    }

    public void removeTag(Tagged tagged) {
        this.allTags.remove(tagged);
        for (String tag : tagged.getTags()) {
            this.tags.remove(tag, tagged);
        }
    }

    public int getTagCount(String tag) {
        return this.tags.sizeOfGroup(tag);
    }

    public int getTaggedCount() {
        return this.allTags.size();
    }

    public String toString() {
        return "TagManager{size=" + this.getTaggedCount() + '}';
    }
}

