/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.AbstractApplicationFactory;
import com.neutronio.astrax.app.DressupLayer;
import com.neutronio.astrax.app.DressupSettings;
import com.neutronio.astrax.app.RepositoryFactory;
import com.neutronio.astrax.app.UserProfile;
import com.neutronio.astrax.app.datapack.NameFactory;
import com.neutronio.astrax.app.main.SavedGame;
import com.neutronio.astrax.app.repository.DressupSettingsRepository;
import com.neutronio.astrax.app.repository.UserProfileRepository;
import com.neutronio.astrax.util.MathUtil;
import com.neutronio.astrax.util.sequences.NumberGenerator;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Logger;

public class UserProfileFactory
extends AbstractApplicationFactory {
    private String[] nameGenPatterns = new String[]{"english-names-male english-surnames", "english-names-female english-surnames", "english-names-neutral english-surnames"};
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private UserProfileRepository userProfileRepository = AstraXApp.astraX.getRepository(UserProfileRepository.class);
    private NumberGenerator numberGenerator = new NumberGenerator(System.currentTimeMillis());

    public void updateAndSaveSavedGame(SavedGame savedGame, Integer chipcoin, Integer discoveryPoints) {
        savedGame.lastPlayed = new Date();
        if (chipcoin != null) {
            savedGame.chipcoin = chipcoin;
        }
        if (discoveryPoints != null) {
            savedGame.discoveryPoints = discoveryPoints;
        }
        this.saveUserRepository();
    }

    public boolean deleteSavedGame(UserProfile userProfile, SavedGame savedGame) {
        userProfile.savedGames.remove(savedGame);
        this.saveUserRepository();
        this.logger.fine("Deleting saved game " + savedGame.gameName + " from disk... ");
        FileHandle path = Gdx.files.local(userProfile.resourcePath).child("saves").child(savedGame.gameName);
        return path.deleteDirectory();
    }

    public UserProfile createUserProfile(String userName) {
        UUID uuid = UUID.randomUUID();
        UserProfile userProfile = new UserProfile();
        userProfile.id = uuid.toString().substring(0, 23);
        userProfile.playerName = userName;
        userProfile.resourcePath = Gdx.files.local("userdata/" + userProfile.id).path();
        return userProfile;
    }

    public UserProfile createRandomUserProfile() {
        UUID uuid = UUID.randomUUID();
        UserProfile userProfile = new UserProfile();
        userProfile.id = uuid.toString().substring(0, 23);
        DressupSettingsRepository repository = AstraXApp.astraX.getRepository(DressupSettingsRepository.class);
        DressupSettings dressupSettings = (DressupSettings)repository.find("avatar_human");
        int layerIndex = 0;
        for (DressupLayer layer : dressupSettings.layers) {
            int random = MathUtil.getRandomInteger(2);
            if (layer.allowNone && random == 0) {
                userProfile.avatarColorIndices[layerIndex] = null;
                userProfile.avatarTextureIndices[layerIndex] = null;
            } else {
                userProfile.avatarColorIndices[layerIndex] = MathUtil.getRandomInteger(layer.availableColors.size());
                userProfile.avatarTextureIndices[layerIndex] = MathUtil.getRandomInteger(layer.definitions.size());
            }
            ++layerIndex;
        }
        String randomPattern = this.numberGenerator.getRandomEntry(this.nameGenPatterns);
        userProfile.playerName = AstraXApp.astraX.getFactoryByClass(NameFactory.class).createName(this.numberGenerator, randomPattern);
        userProfile.resourcePath = Gdx.files.local("userdata/" + userProfile.id).path();
        return userProfile;
    }

    public void addUserProfileToRepository(UserProfile profile) {
        if (this.userProfileRepository == null) {
            this.userProfileRepository = AstraXApp.astraX.getRepository(UserProfileRepository.class);
        }
        if (!this.userProfileRepository.contains(profile.id)) {
            this.userProfileRepository.add(profile.id, profile);
        }
    }

    public void removeUserProfileFromRepository(String uid) {
        if (this.userProfileRepository == null) {
            this.userProfileRepository = AstraXApp.astraX.getRepository(UserProfileRepository.class);
        }
        this.userProfileRepository.remove(uid);
    }

    public void createFoldersOnDisk(UserProfile userProfile) {
        this.logger.info("Creating folders for profile " + userProfile.id);
        ArrayList<File> dirsToCreate = new ArrayList<File>();
        dirsToCreate.add(new File(userProfile.resourcePath, "saves"));
        dirsToCreate.add(new File(userProfile.resourcePath, "screenshots"));
        dirsToCreate.add(new File(userProfile.resourcePath, "data/spacecraft"));
        for (File dir : dirsToCreate) {
            boolean success = dir.mkdirs();
            this.logger.finest("... Creating folder " + dir.getAbsolutePath() + " " + success);
        }
    }

    public void deleteFolderFromDisk(UserProfile userProfile) {
        this.logger.info("Removing folders for profile " + userProfile.id);
        File baseDir = new File(userProfile.resourcePath);
        this.deleteDir(baseDir);
    }

    private void deleteDir(File file) {
        this.logger.finest("... Removing folder: " + file.toString());
        File[] contents = file.listFiles();
        if (contents != null) {
            for (File f : contents) {
                if (Files.isSymbolicLink(f.toPath())) continue;
                this.deleteDir(f);
            }
        }
        file.delete();
    }

    public UserProfile getUserProfile(String id) {
        return null;
    }

    public void saveUserRepository() {
        if (this.userProfileRepository == null) {
            this.userProfileRepository = AstraXApp.astraX.getRepository(UserProfileRepository.class);
        }
        RepositoryFactory repositoryFactory = AstraXApp.astraX.getRepositoryFactory();
        repositoryFactory.save(this.userProfileRepository, "userdata", "users.json", true);
    }
}

