/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.concurrent;

import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;

public class Worker
implements Runnable {
    private String name;
    private Thread thread;
    private boolean running = true;
    private Stack<WorkerTask> tasks = new Stack();
    private ConcurrentHashMap<Long, Object> results = new ConcurrentHashMap();

    public Worker(String name) {
        this.name = name;
    }

    public void start() {
        this.thread = new Thread((Runnable)this, "AstraX-" + this.name);
        this.thread.start();
    }

    public void stop() {
        this.running = false;
    }

    public long scheduleTask(WorkerTask task) {
        this.tasks.push(task);
        return task.id;
    }

    public Object getTaskResult(long scheduleId) {
        return this.results.remove(scheduleId);
    }

    @Override
    public void run() {
        while (this.running) {
            if (this.tasks.isEmpty()) continue;
            WorkerTask task = this.tasks.pop();
            try {
                System.out.println("Execution Task " + task.id);
                Object result = task.execute();
                this.results.put(task.id, result);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static abstract class WorkerTask {
        private static long globalId;
        private long id = ++globalId;

        public abstract Object execute();
    }
}

