/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.Factory;
import com.neutronio.astrax.app.datapack.DataPackSettings;
import com.neutronio.astrax.app.datapack.EntityIDFactory;
import com.neutronio.astrax.app.datapack.game.Game;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.ProbabilitySetGenerator;
import com.neutronio.astrax.app.generator.TreeGenerator;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.util.Counter;
import com.neutronio.astrax.util.sequences.NumberGenerator;
import com.neutronio.astrax.util.sequences.StringGenerator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataPack {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private Game game;
    private String name;
    private String version = "0";
    private TextureAtlas textureAtlas;
    private DataPackSettings dataPackSettings;
    @Deprecated
    private NumberGenerator numberGenerator;
    @Deprecated
    private StringGenerator stringGenerator;
    @Deprecated
    private TreeGenerator treeGenerator;
    @Deprecated
    private EntityIDFactory entityIDFactory;
    @Deprecated
    private ProbabilitySetGenerator setGenerator;
    private Counter<String> specimenCounter = new Counter();

    public DataPack() {
    }

    public DataPack(Game game) {
        this.game = game;
    }

    public void init() {
        if (this.numberGenerator == null) {
            this.numberGenerator = new NumberGenerator(0L);
            this.treeGenerator = new TreeGenerator();
            this.stringGenerator = new StringGenerator();
            this.entityIDFactory = new EntityIDFactory(this.stringGenerator);
            this.setGenerator = new ProbabilitySetGenerator();
            this.setSeed(this.game == null ? (long)MathUtils.random(1000) : this.game.getSeed());
        }
    }

    public void setGame(Game game) {
        this.game = game;
        this.setSeed(this.game == null ? 333L : this.game.getSeed());
    }

    public Game getGame() {
        return this.game;
    }

    public DataPackSettings getDataPackSettings() {
        return this.dataPackSettings;
    }

    public void setDataPackSettings(DataPackSettings dataPackSettings) {
        this.dataPackSettings = dataPackSettings;
    }

    public void initFactories(DataManager dataManager) {
        Map<Class, Factory> loadedFactories = dataManager.getLoadedFactories();
        for (Factory factory : loadedFactories.values()) {
            if (!(factory instanceof AbstractFactory)) continue;
            ((AbstractFactory)factory).setDataPack(this);
        }
    }

    public void countSpecimen(String specimenId) {
        this.specimenCounter.addOne(specimenId);
    }

    public boolean canSpawnSpecimen(String specimenId, int maxSpecimens) {
        return this.specimenCounter.get(specimenId) < maxSpecimens;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public TextureAtlas getTextureAtlas() {
        return this.textureAtlas;
    }

    public void setTextureAtlas(TextureAtlas textureAtlas) {
        this.textureAtlas = textureAtlas;
    }

    public ProbabilitySetGenerator getSetGenerator() {
        return this.setGenerator;
    }

    public NumberGenerator getNumberGenerator() {
        return this.numberGenerator;
    }

    public TreeGenerator getTreeGenerator() {
        return this.treeGenerator;
    }

    public StringGenerator getStringGenerator() {
        return this.stringGenerator;
    }

    public EntityIDFactory getEntityIDFactory() {
        return this.entityIDFactory;
    }

    public TextureAtlas.AtlasRegion getRandomTexture(String textureRegionName) {
        Array<TextureAtlas.AtlasRegion> regions = this.textureAtlas.findRegions(textureRegionName);
        if (regions.isEmpty()) {
            this.logger.log(Level.FINE, "Texture Regions: " + this.textureAtlas.getRegions());
            throw new AstraXException(AstraXException.ErrorCode.E3111, textureRegionName);
        }
        return this.numberGenerator.getRandomEntry(regions);
    }

    public TextureAtlas.AtlasRegion getTexture(String textureRegionName) {
        TextureAtlas.AtlasRegion region = this.textureAtlas.findRegion(textureRegionName);
        if (region == null) {
            this.logger.log(Level.FINE, "Texture Regions: " + this.textureAtlas.getRegions());
            throw new AstraXException(AstraXException.ErrorCode.E3111, textureRegionName);
        }
        return region;
    }

    private void setSeed(long seed) {
        this.numberGenerator.setSeed(seed);
    }
}

