/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.AbstractApplicationFactory;
import com.neutronio.astrax.app.RepositoryFactory;
import com.neutronio.astrax.app.datapack.DataPack;
import com.neutronio.astrax.app.datapack.DataPackSettings;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.io.FileHandler;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class DataPackFactory
extends AbstractApplicationFactory
implements GenericFactory<DataPack, DataPackSettings> {
    public DataPackFactory(AstraXApp game) {
        super(game);
    }

    @Override
    public DataPack create(DataPackSettings dataPackSettings) {
        this.logger.log(Level.INFO, "Loading Datapack: " + dataPackSettings.name);
        DataPack dataPack = new DataPack();
        dataPack.setVersion(dataPackSettings.version);
        dataPack.setName(dataPackSettings.name);
        dataPack.setDataPackSettings(dataPackSettings);
        TextureAtlas textureAtlas = this.loadTextureAtlas("mods/" + dataPackSettings.name + "/" + dataPackSettings.textureAtlas, dataPackSettings.fileLocation);
        dataPack.setTextureAtlas(textureAtlas);
        this.loadRepositories(dataPack, dataPackSettings);
        dataPack.init();
        dataPack.initFactories(AstraXApp.astraX.getRepositoryFactory().getDataManager());
        AstraXApp.astraX.getSoundLoader().loadSoundsIntoSoundManagers(dataPackSettings);
        return dataPack;
    }

    public List<DataPackOnDisk> findExternalDataPacks(String path) {
        FileFilter fileFilter = new FileFilter();
        ArrayList<DataPackOnDisk> externalMods = new ArrayList<DataPackOnDisk>();
        File modFolderFile = new File(path);
        int modsFound = 0;
        if (modFolderFile.isDirectory()) {
            File[] mods;
            for (File mod : mods = modFolderFile.listFiles()) {
                File[] modFiles = mod.listFiles(fileFilter);
                if (modFiles.length > 0) {
                    externalMods.add(new DataPackOnDisk(mod, modFiles[0]));
                    ++modsFound;
                    continue;
                }
                this.logger.warning("Could not load mod: mods.json is missing in folder " + mod);
            }
        }
        this.logger.info(modsFound + " mods found");
        return externalMods;
    }

    public List<DataPackSettings> getSettingsFromFoundMods(List<DataPackOnDisk> foundMods) {
        ArrayList<DataPackSettings> modlist = new ArrayList<DataPackSettings>();
        this.logger.log(Level.INFO, "Loading DataPackSettings...");
        for (DataPackOnDisk mod : foundMods) {
            this.logger.fine("Modpath: " + mod.baseDir.getPath() + " ");
            FileHandle settingsHandle = Gdx.files.local(mod.settingsFile.getPath());
            if (settingsHandle != null) {
                DataPackSettings dataPackSettings = this.gameContainer.getRepositoryFactory().getDataManager().load(DataPackSettings.class, settingsHandle.readString());
                modlist.add(dataPackSettings);
                continue;
            }
            this.logger.warning("Could not load settings for " + mod.settingsFile.getPath());
        }
        return modlist;
    }

    private void loadRepositories(DataPack pack, DataPackSettings fromSettings) {
        RepositoryFactory repositoryFactory = AstraXApp.astraX.getRepositoryFactory();
        fromSettings.repositoryLoaderSettings.setRootPath("mods/" + fromSettings.name + "/");
        repositoryFactory.loadConfiguration(fromSettings.repositoryLoaderSettings);
    }

    public TextureAtlas loadTextureAtlas(String filename, FileHandler.FileLocation location) {
        this.logger.log(Level.FINE, "Loading Texture Atlas: " + filename + " location: " + (Object)((Object)location));
        FileHandle fileHandle = AstraXFiles.toGdxFileHandle(filename, location);
        TextureAtlas textureAtlas = new TextureAtlas(fileHandle);
        return textureAtlas;
    }

    static class FileFilter
    implements FilenameFilter {
        FileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.equals("mod.json");
        }
    }

    public static class DataPackOnDisk {
        public File baseDir;
        public File settingsFile;

        public DataPackOnDisk(File baseDir, File settingsFile) {
            this.baseDir = baseDir;
            this.settingsFile = settingsFile;
        }
    }
}

