/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack;

import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.util.sequences.NumberGenerator;
import com.neutronio.astrax.util.sequences.StringGenerator;

public class EntityIDFactory {
    private StringGenerator stringGenerator;
    private int idLength = 10;

    public EntityIDFactory(StringGenerator generator) {
        this.stringGenerator = generator;
    }

    public int getIdLength() {
        return this.idLength;
    }

    public void setIdLength(int idLength) {
        this.idLength = idLength;
    }

    public EntityID createID(NumberGenerator numberGenerator, String prefix, int length) {
        if (prefix == null) {
            throw new NullPointerException("Prefix cannot be null!");
        }
        StringBuilder randomString = this.stringGenerator.getRandomString(numberGenerator, length);
        randomString.insert(0, prefix + "_");
        return new EntityID(randomString.toString());
    }

    public EntityID createID(NumberGenerator numberGenerator, String prefix) {
        return this.createID(numberGenerator, prefix, this.idLength);
    }

    public EntityID createID(NumberGenerator numberGenerator) {
        return new EntityID(this.stringGenerator.getRandomString(numberGenerator, this.idLength).toString());
    }

    public EntityID get(String id) {
        return new EntityID(id);
    }
}

