/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector2;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.RepositoryFactory;
import com.neutronio.astrax.app.UserProfile;
import com.neutronio.astrax.app.UserProfileFactory;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.Game;
import com.neutronio.astrax.app.datapack.game.GameFactory;
import com.neutronio.astrax.app.datapack.game.GameSettings;
import com.neutronio.astrax.app.datapack.game.Trader;
import com.neutronio.astrax.app.datapack.game.world.AsteroidTarget;
import com.neutronio.astrax.app.datapack.game.world.Discovery;
import com.neutronio.astrax.app.datapack.game.world.GalaxyMapContext;
import com.neutronio.astrax.app.datapack.game.world.Merchant;
import com.neutronio.astrax.app.datapack.game.world.NPCTrader;
import com.neutronio.astrax.app.datapack.game.world.Player;
import com.neutronio.astrax.app.datapack.game.world.PlayerFactory;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.World;
import com.neutronio.astrax.app.datapack.game.world.WorldFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Sector;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.Asteroid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.AsteroidData;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteHeader;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SavedSatellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoverySystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.trade.TradeSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StarSystemHeader;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.main.SavedGame;
import com.neutronio.astrax.app.screen.SpaceScreen;
import com.neutronio.astrax.gfx.SatelliteGraphics;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.io.json.config.JSONToGameSettings;
import com.neutronio.astrax.util.date.Timespan;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GameSessionFactory
extends AbstractFactory {
    private UserProfileFactory userProfileFactory;
    private GameFactory gameFactory;
    private PlayerFactory playerFactory;
    private WorldFactory worldFactory;
    private RepositoryFactory repositoryFactory;
    private GalaxyMapContext galaxyMapContext;

    public GameSessionFactory(DataContext dataContext) {
        super(dataContext);
        this.gameFactory = dataContext.getFactory(GameFactory.class);
        this.playerFactory = dataContext.getFactory(PlayerFactory.class);
        this.worldFactory = dataContext.getFactory(WorldFactory.class);
        this.userProfileFactory = dataContext.getFactory(UserProfileFactory.class);
        this.repositoryFactory = AstraXApp.astraX.getRepositoryFactory();
    }

    public void setGalaxyMapContext(GalaxyMapContext galaxyMapContext) {
        this.galaxyMapContext = galaxyMapContext;
    }

    public void newGame(SpaceScreen spaceScreen, UserProfile profile, GameSettings gameSettings) {
        Game game = this.gameFactory.createGame(profile, gameSettings);
        spaceScreen.setAstraxGame(game);
        World world = this.worldFactory.create(game, gameSettings.worldSettings);
        game.setWorld(world);
        AstraXApp.astraX.getSfxSoundManager().setCamera((OrthographicCamera)spaceScreen.getWorldStage().getCamera());
        Player player = this.playerFactory.create(gameSettings.worldSettings.getPlayerSettings());
        world.setLocalPlayer(player);
        SatelliteTarget playerSatellite = this.playerFactory.createPlayerSatellite(gameSettings.worldSettings.getPlayerSettings().shipName, gameSettings.worldSettings.getPlayerSettings().satelliteGridFile, gameSettings.worldSettings.getPlayerSettings().satelliteGrid);
        TradeSystem tradeSystem = ((Satellite)playerSatellite.getModel()).getSystem(TradeSystem.class);
        tradeSystem.setTrader(player);
        Discovery discovery = this.galaxyMapContext.getDiscoveryFactory().createDiscovery(playerSatellite);
        try {
            world.getGalaxyMapContext().getDiscoveryDAO().insert(discovery);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        player.setPlayerTarget(discovery, playerSatellite);
        DiscoverySystem discoverySystem = ((Satellite)player.getPlayerTarget().getModel()).getSystem(DiscoverySystem.class);
        discoverySystem.getScanner().setGalaxyMapContext(world.getGalaxyMapContext());
        discoverySystem.addDiscoveryTarget(player.getDiscoveryTarget());
        world.getSpawnManager().spawnTarget(player.getPlayerTarget(), gameSettings.worldSettings.getGalaxySettings().xSectorStartPos * world.getSectorTracker().getSectorBoundsY(), gameSettings.worldSettings.getGalaxySettings().ySectorStartPos * world.getSectorTracker().getSectorBoundsY());
        SavedGame savedGame = new SavedGame(game.getName(), world.getGalaxy().getName());
        game.setSavedGame(savedGame);
        profile.savedGames.add(savedGame);
        AstraXApp.astraX.getAppFactoryByClass(UserProfileFactory.class).updateAndSaveSavedGame(savedGame, gameSettings.worldSettings.getPlayerSettings().chips, gameSettings.worldSettings.getPlayerSettings().discoveryPoints);
    }

    public void loadGame(SpaceScreen spaceScreen, UserProfile profile, SavedGame savedGame) throws SQLException {
        FileHandle gameDirectory = Gdx.files.local(profile.resourcePath).child("saves").child(savedGame.gameName);
        Game game = this.gameFactory.loadGame(gameDirectory);
        spaceScreen.setAstraxGame(game);
        World world = this.worldFactory.load(savedGame, game);
        game.setWorld(world);
        AstraXApp.astraX.getSfxSoundManager().setCamera((OrthographicCamera)spaceScreen.getWorldStage().getCamera());
        Player player = this.playerFactory.loadPlayer("player.dat", game.getGameDirectory());
        world.setLocalPlayer(player);
        SatelliteTarget playerTarget = this.worldFactory.loadPlayerSpacecraft(world);
        Discovery discovery = world.getGalaxyMapContext().getDiscoveryDAO().getByEntityId(playerTarget.getID().get());
        player.setPlayerTarget(discovery, playerTarget);
        DiscoverySystem discoverySystem = ((Satellite)player.getPlayerTarget().getModel()).getSystem(DiscoverySystem.class);
        discoverySystem.getScanner().setGalaxyMapContext(world.getGalaxyMapContext());
        discoverySystem.addDiscoveryTarget(player.getDiscoveryTarget());
        TradeSystem tradeSystem = ((Satellite)player.getPlayerTarget().getModel()).getSystem(TradeSystem.class);
        tradeSystem.setTrader(player);
        AstraXApp.astraX.getAppFactoryByClass(UserProfileFactory.class).updateAndSaveSavedGame(savedGame, null, null);
        game.setSavedGame(savedGame);
    }

    public void saveGame(Game game, World world) {
        this.logger.info("Saving game...");
        if (world.getLocalPlayer() != null) {
            Date now = new Date();
            Timespan timespan = new Timespan(now.getTime() / 1000L - game.getSessionStart().getTime() / 1000L);
            game.getGameSettings().timePlayed.add(timespan);
            JSONToGameSettings jsonToGameSettings = this.repositoryFactory.getDataManager().getConverter(JSONToGameSettings.class);
            this.repositoryFactory.save(game.getGameSettings(), jsonToGameSettings, game.getGameDirectory().path(), "game.json", true);
            this.saveGameInfo(game, world.getLocalPlayer());
            this.savePlayer(world.getLocalPlayer(), game.getGameDirectory());
            this.saveNPCSatellites(world.getSectorStream().getCurrentSector().getChunk().getSystemMembers());
        }
    }

    public void saveGameInfo(Game game, Player player) {
        SavedGame savedGame = game.getSavedGame();
        savedGame.lastPlayed = new Date();
        savedGame.discoveryPoints = player.getDiscoveryPoints();
        savedGame.chipcoin = player.getChips();
        savedGame.playTime = game.getGameSettings().timePlayed;
        UserProfileFactory userProfileFactory = AstraXApp.astraX.getAppFactoryByClass(UserProfileFactory.class);
        userProfileFactory.saveUserRepository();
    }

    public void loadMerchants(List<SatelliteTarget> targets) {
        int tradersLoaded = 0;
        for (SatelliteTarget satelliteTarget : targets) {
            try {
                Merchant merchant = this.galaxyMapContext.getMerchantDAO().get(satelliteTarget.getID().get());
                TradeSystem tradeSystem = ((Satellite)satelliteTarget.getModel()).getSystem(TradeSystem.class);
                if (!(tradeSystem.getTrader() instanceof NPCTrader) || merchant == null) continue;
                ((NPCTrader)tradeSystem.getTrader()).setMerchant(merchant);
                ++tradersLoaded;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.logger.finest("Loaded " + tradersLoaded + " Merchants into NPC Spacecraft!");
    }

    public void savePlayer(Player player, FileHandle gameDirectory) {
        FileHandler.State state = AstraXApp.astraX.getAstraXFiles().saveFileBinary((Serializable)player, "player.dat", gameDirectory);
        if (Objects.equals((Object)state, (Object)FileHandler.State.FAILED)) {
            AstraXApp.astraX.showErrorAlert("Error saving Player!");
        }
        this.saveSatellite(player.getPlayerTarget(), 1);
    }

    public void saveNPCSatellites(Collection<Targetable> members) {
        for (Targetable targetable : members) {
            if (!(targetable instanceof SatelliteTarget)) continue;
            this.saveSatellite((SatelliteTarget)targetable, (int)System.currentTimeMillis());
        }
    }

    public void saveSatellite(SatelliteTarget satellite, int id) {
        SatelliteHeader satelliteHeader = new SatelliteHeader();
        satelliteHeader.satelliteId = id;
        satelliteHeader.uuid = satellite.getID().get();
        satelliteHeader.name = satellite.getName();
        satelliteHeader.modelName = ((Satellite)satellite.getModel()).getSatelliteGrid().name;
        Vector2 worldPosition = satellite.getWorldPosition();
        satelliteHeader.x = (int)worldPosition.x;
        satelliteHeader.y = (int)worldPosition.y;
        satelliteHeader.rotation = (int)((SatelliteGraphics)satellite.getGraphics()).getRotation();
        try {
            if (this.galaxyMapContext.getSatelliteDAO().exists(id)) {
                this.galaxyMapContext.getSatelliteDAO().update(satelliteHeader);
                this.updateMerchant(satellite);
            } else {
                this.galaxyMapContext.getSatelliteDAO().insert(satelliteHeader);
                this.saveMerchant(satellite);
            }
            this.galaxyMapContext.getSatelliteDAO().storeBinary(satelliteHeader.satelliteId, new SavedSatellite((Satellite)satellite.getModel()));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void saveMerchant(SatelliteTarget satelliteMerchant) throws SQLException {
        TradeSystem system = ((Satellite)satelliteMerchant.getModel()).getSystem(TradeSystem.class);
        Trader trader = system.getTrader();
        if (trader instanceof NPCTrader) {
            if (this.galaxyMapContext.getMerchantDAO().exists(satelliteMerchant.getID().get())) {
                this.galaxyMapContext.getMerchantDAO().update(((NPCTrader)trader).getMerchant());
            } else {
                this.galaxyMapContext.getMerchantDAO().insert(((NPCTrader)trader).getMerchant());
            }
        }
    }

    public void updateMerchant(SatelliteTarget satelliteMerchant) throws SQLException {
        TradeSystem system = ((Satellite)satelliteMerchant.getModel()).getSystem(TradeSystem.class);
        Trader trader = system.getTrader();
        if (trader instanceof NPCTrader) {
            this.galaxyMapContext.getMerchantDAO().update((Merchant)((Object)trader));
        }
    }

    public void saveAsteroids(Sector<StarSystem> sector) {
        ArrayList<AsteroidData> asteroidData = new ArrayList<AsteroidData>();
        for (Targetable targetable : sector.getChunk().getSystemMembers()) {
            if (!(targetable instanceof AsteroidTarget)) continue;
            asteroidData.add(new AsteroidData(sector.getTileID(), (AsteroidTarget)targetable));
        }
        try {
            this.galaxyMapContext.getAsteroidDAO().insertAll(asteroidData);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateAsteroids(Sector<StarSystem> sector) {
        ArrayList<AsteroidData> asteroidData = new ArrayList<AsteroidData>();
        for (Targetable targetable : sector.getChunk().getSystemMembers()) {
            if (!(targetable instanceof AsteroidTarget)) continue;
            asteroidData.add(new AsteroidData(sector.getTileID(), (AsteroidTarget)targetable));
        }
        try {
            this.galaxyMapContext.getAsteroidDAO().updateAll(asteroidData);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void synchronizeAsteroidsWithDatabase(Sector<StarSystem> sector) {
        try {
            List<AsteroidData> asteroidData = this.galaxyMapContext.getAsteroidDAO().getAll(sector.getTileID());
            if (asteroidData == null) {
                this.logger.warning("Could not synchronize Asteroids: none were saved!");
                return;
            }
            for (AsteroidData asteroid : asteroidData) {
                Targetable member = sector.getChunk().findMember(new EntityID(asteroid.entityID));
                if (member instanceof AsteroidTarget) {
                    AsteroidTarget asteroidTarget = (AsteroidTarget)member;
                    ((Asteroid)asteroidTarget.getModel()).getResourceDeposit().setDepositSize(asteroid.remainingDeposit);
                    continue;
                }
                this.logger.warning("Could not synchronize Asteroid of entityID " + asteroid.entityID + " with database contents!");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<DiscoveryTarget> createEmptyDiscoveryTargetList(Collection<Targetable> systemMembers) {
        ArrayList<DiscoveryTarget> discoveryTargets = new ArrayList<DiscoveryTarget>();
        for (Targetable target : systemMembers) {
            discoveryTargets.add(new DiscoveryTarget<Targetable>(null, target));
        }
        return discoveryTargets;
    }

    public List<DiscoveryTarget> loadAndCreateDiscoveryTargets(StarSystemHeader starSystem, Collection<Targetable> systemMembers) throws SQLException {
        this.logger.finest("Load target Discoveries available for this sector & apply visibility...");
        ArrayList<DiscoveryTarget> discoveryTargets = new ArrayList<DiscoveryTarget>();
        Map<String, Discovery> discoveries = this.galaxyMapContext.getDiscoveryDAO().getByFilter(starSystem.id, Discovery.Classification.STAR.ordinal(), Discovery.Classification.ASTEROID.ordinal(), Discovery.Classification.SPACECRAFT.ordinal(), Discovery.Classification.BELT.ordinal(), Discovery.Classification.WRECK.ordinal());
        for (Targetable target : systemMembers) {
            discoveryTargets.add(new DiscoveryTarget<Targetable>(discoveries.get(target.getID().get()), target));
        }
        return discoveryTargets;
    }
}

