/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack;

import com.neutronio.astrax.app.CreationSettings;
import com.neutronio.astrax.app.datapack.DataRepositorySetting;
import com.neutronio.astrax.app.datapack.FactorySettings;
import com.neutronio.astrax.app.datapack.TranslationSettings;
import com.neutronio.astrax.app.repository.DataRepository;
import com.neutronio.astrax.io.json.JSONConverter;
import com.neutronio.astrax.io.json.game.JSONRepositoryConverter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RepositoryLoaderSettings
implements CreationSettings {
    private String rootPath;
    private List<Class<? extends JSONConverter>> converters = new ArrayList<Class<? extends JSONConverter>>();
    private List<DataRepositorySetting> repositorySettings = new ArrayList<DataRepositorySetting>();
    private List<FactorySettings.FactorySetting> facxtorySettings = new ArrayList<FactorySettings.FactorySetting>();
    private Map<String, TranslationSettings> translations = new LinkedHashMap<String, TranslationSettings>();

    public List<DataRepositorySetting> getRepositorySettings() {
        return this.repositorySettings;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public DataRepositorySetting findRepositorySettingOf(Class<DataRepository> clazz) {
        for (DataRepositorySetting setting : this.repositorySettings) {
            if (!Objects.equals(setting.clazz, clazz)) continue;
            return setting;
        }
        return null;
    }

    public void putTranslations(TranslationSettings settings) {
        if (this.translations.containsKey(settings.bundleName)) {
            return;
        }
        this.translations.put(settings.bundleName, settings);
    }

    public Map<String, TranslationSettings> getTranslations() {
        return this.translations;
    }

    public void addConverter(Class<? extends JSONConverter> type) {
        this.converters.add(type);
    }

    public void addRepositorySetting(DataRepositorySetting setting) {
        this.repositorySettings.add(setting);
    }

    public void addFactorySetting(FactorySettings.FactorySetting factorySetting) {
        this.facxtorySettings.add(factorySetting);
    }

    public void addRepository(String path, Class<? extends DataRepository> type, Class<? extends JSONRepositoryConverter> repoConverterClass) {
        this.repositorySettings.add(new DataRepositorySetting(path, type, repoConverterClass));
    }

    private void addRepository(DataRepositorySetting setting) {
        this.repositorySettings.add(setting);
    }

    public List<FactorySettings.FactorySetting> getFacxtorySettings() {
        return this.facxtorySettings;
    }

    public int getConverterCount() {
        return this.converters.size();
    }

    public Class<? extends JSONConverter> getConverter(int index) {
        return this.converters.get(index);
    }

    public boolean contains(Class<? extends JSONConverter> converterClass) {
        return this.repositorySettings.contains(converterClass);
    }
}

