/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Commands {
    private boolean verbose = true;
    private Map<String, Command> commands = new HashMap<String, Command>();

    public Command removeCommand(String commandCall) {
        return this.commands.remove(commandCall);
    }

    public void addCommand(String commandCall, Command command) {
        this.commands.put(commandCall, command);
    }

    public String parse(String input) {
        String[] split = input.split(Pattern.quote(" "));
        return this.execute(split[0], Arrays.copyOfRange(split, 1, split.length));
    }

    public String execute(String commandString, String ... params) {
        int status = this.executeNonVerbose(commandString, params);
        if (!this.verbose) {
            return null;
        }
        switch (status) {
            case -1: {
                return "Could not execute command '" + commandString + "':  Parse Error!";
            }
            case 0: {
                return "No command of this name exists: '" + commandString + "'";
            }
        }
        return "Command executed!";
    }

    public int executeNonVerbose(String commandString, String ... params) {
        Command command = this.commands.get(commandString);
        if (command == null) {
            return 0;
        }
        int status = command.execute(params);
        return status;
    }

    public static void main(String[] args) {
        Commands commands = new Commands();
        Command spawn = new Command(){

            @Override
            public int execute(String ... params) {
                if (params.length > 0) {
                    return -1;
                }
                System.out.println("Spawning!");
                return 0;
            }

            @Override
            public String getUsage() {
                return "spawn\tteleports you to world spawn location";
            }
        };
        Command teleport = new Command(){

            @Override
            public int execute(String ... params) {
                if (params.length != 2) {
                    return -1;
                }
                try {
                    int x = Integer.parseInt(params[0]);
                    int y = Integer.parseInt(params[1]);
                    System.out.println("Teleporting to " + x + " " + y);
                    return 0;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    return -1;
                }
            }

            @Override
            public String getUsage() {
                return "tp [x:int] [y:int]\tteleports you to a given location";
            }
        };
        commands.commands.put("spawn", spawn);
        commands.commands.put("tp", teleport);
        commands.verbose = false;
        System.out.println(commands.parse("spawn derp"));
        System.out.println(commands.parse("spawnderp"));
        System.out.println(commands.parse("spawn"));
        System.out.println(commands.parse("tp"));
        System.out.println(commands.parse("tp x 3"));
        System.out.println(commands.parse("tp 20 32"));
    }

    static interface Command {
        public int execute(String ... var1);

        public String getUsage();
    }
}

