/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.NavTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.World;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Sector;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.NavigationBookmark;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.TargetComputer;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StarSystemHeader;
import com.neutronio.astrax.gfx.NavigationGraphics;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.util.Vector2i;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class BookmarkManager {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private World world;
    private TargetComputer targetComputer;
    private Map<String, NavTarget> navTargets = new HashMap<String, NavTarget>();

    public BookmarkManager(World world) {
        this.world = world;
    }

    public NavTarget getNavTarget(String entityID) {
        return this.navTargets.get(entityID);
    }

    public void init(TargetComputer computer) {
        this.logger.fine("Init Bookmark Manager...");
        this.targetComputer = computer;
        for (NavigationBookmark bookmark : this.targetComputer.getNavigationBookmarks().values()) {
            NavTarget navTarget = new NavTarget(new EntityID("bookmark_" + bookmark.entityId));
            navTarget.setParentBookmark(bookmark);
            navTarget.setModel(bookmark);
            navTarget.setGraphics(new NavigationGraphics(AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class)));
            this.navTargets.put(bookmark.entityId, navTarget);
        }
    }

    public NavTarget addBookmarkForTracking(NavigationBookmark bookmark) {
        NavTarget navTarget = new NavTarget(new EntityID("bookmark_" + bookmark.entityId));
        navTarget.setParentBookmark(bookmark);
        navTarget.setModel(bookmark);
        navTarget.setGraphics(new NavigationGraphics(AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class)));
        this.navTargets.put(bookmark.entityId, navTarget);
        return navTarget;
    }

    public void removeBookmarkForTracking(NavigationBookmark bookmark) {
        NavTarget navTarget = this.navTargets.get(bookmark.entityId);
        this.world.getSpawnManager().despawnTarget(navTarget);
        this.navTargets.remove(bookmark);
    }

    public void updateBookmarkState(Sector<StarSystem> currentSector) {
        if (this.targetComputer == null) {
            this.logger.warning("TargetComputer not set yet! Method does nothing. Please improve lifecycle infrastructure");
            return;
        }
        this.logger.fine("Update Bookmark State...");
        for (NavigationBookmark bookmark : this.targetComputer.getNavigationBookmarks().values()) {
            if (bookmark.sectorId == currentSector.getTileID()) {
                Targetable member = currentSector.getChunk().findMember(new EntityID(bookmark.entityId));
                if (member != null) {
                    this.spawnBookmarkIntoWorld(bookmark, member);
                    continue;
                }
                this.logger.warning("Something went wrong: Member is not part of the current star system for some reason.");
                this.logger.warning("Bookmark is placed into limbo as fallback.");
                this.placeBookmarkIntoLimbo(bookmark);
                continue;
            }
            this.placeBookmarkIntoLimbo(bookmark);
        }
    }

    private void spawnBookmarkIntoWorld(NavigationBookmark bookmark, Targetable member) {
        NavTarget navTarget = this.navTargets.get(bookmark.entityId);
        navTarget.setFollowMode(NavTarget.FOLLOW_MODE_TARGET);
        navTarget.setFollowedTarget(member);
        if (!((NavigationGraphics)navTarget.getGraphics()).hasParent()) {
            this.world.getSpawnManager().spawnTarget(navTarget, (int)member.getWorldPosition().x, (int)member.getWorldPosition().y);
            ((NavigationGraphics)navTarget.getGraphics()).toFront();
            this.logger.fine("NavTarget for Bookmark '" + bookmark.name + "' placed in world");
        }
    }

    private void placeBookmarkIntoLimbo(NavigationBookmark bookmark) {
        NavTarget navTarget = this.navTargets.get(bookmark.entityId);
        StarSystemHeader externalStarSystem = null;
        if (navTarget.getFollowMode() == NavTarget.FOLLOW_MODE_POSITION) {
            return;
        }
        try {
            externalStarSystem = this.world.getGalaxyMapContext().getStarSystemHeaderDAO().get(bookmark.sectorId);
            Vector2i worldPos = this.world.globalSectorToWorldPosition(externalStarSystem.x.shortValue(), externalStarSystem.y.shortValue());
            navTarget.setFollowMode(NavTarget.FOLLOW_MODE_POSITION);
            navTarget.setFollowedTarget(null);
            navTarget.setFollowedPosition(worldPos.x, worldPos.y);
            this.world.getSpawnManager().despawnTarget(navTarget);
            this.logger.fine("NavTarget for Bookmark '" + bookmark.name + "' placed in limbo at " + worldPos.x + " " + worldPos.y);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

