/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.MapFactory;
import com.neutronio.astrax.app.datapack.game.world.AsteroidTarget;
import com.neutronio.astrax.app.datapack.game.world.BeltTarget;
import com.neutronio.astrax.app.datapack.game.world.CelestialTarget;
import com.neutronio.astrax.app.datapack.game.world.Discovery;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetTrait;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Planet;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.screen.SpaceScreen;
import com.neutronio.astrax.ui.ComponentFactory;
import java.util.List;

public class DiscoveryFactory
extends AbstractFactory
implements MapFactory {
    public DiscoveryFactory(DataContext dataContext) {
        super(dataContext);
    }

    public PlanetTrait getNextTrait(CelestialTarget celestialTarget, List<String> childDiscoveries) {
        List traits = AstraXApp.astraX.getRepositoryFactory().findResourcesByIDs(((Planet)celestialTarget.getModel()).getCustomPlanetSettings().traits);
        this.logger.finest("Traits: " + traits);
        this.logger.finest("Child Discoveries: " + childDiscoveries);
        if (childDiscoveries == null) {
            return (PlanetTrait)traits.get(0);
        }
        for (PlanetTrait trait : traits) {
            if (childDiscoveries.contains(trait.id)) continue;
            return trait;
        }
        return null;
    }

    public Discovery createDiscovery(PlanetTrait trait) {
        Discovery discovery = new Discovery();
        discovery.id = (int)System.currentTimeMillis();
        discovery.entityId = trait.id;
        discovery.name = AstraXApp.astraX.getRepositoryFactory().getDataManager().translateMarked(trait.name);
        discovery.description = AstraXApp.astraX.getRepositoryFactory().getDataManager().translateMarked(trait.description);
        discovery.icon = trait.icon;
        discovery.rarity = Discovery.Rarity.UNCOMMON;
        discovery.classification = Discovery.Classification.PLANET_TRAIT;
        discovery.discoveryPoints = 10;
        return discovery;
    }

    public Discovery createDiscovery(Targetable target) {
        if (target instanceof CelestialTarget) {
            return this.createDiscovery((CelestialTarget)target);
        }
        if (target instanceof SatelliteTarget) {
            return this.createDiscovery((SatelliteTarget)target);
        }
        if (target instanceof AsteroidTarget) {
            return this.createDiscovery((AsteroidTarget)target);
        }
        return this.createBasicDiscovery(target);
    }

    public Discovery createDiscovery(CelestialTarget target) {
        Discovery discovery = this.createBasicDiscovery(target);
        discovery.classification = Discovery.Classification.STAR;
        discovery.starSystemId = AstraXApp.astraX.getScreen(SpaceScreen.class).getAstraxGame().getWorld().getSectorStream().getCurrentSector().getTileID();
        if (((Planet)target.getModel()).getCustomPlanetSettings() != null) {
            discovery.rarity = ((Planet)target.getModel()).getCustomPlanetSettings().rarity;
            discovery.discoveryPoints = ((Planet)target.getModel()).getCustomPlanetSettings().discoveryPoints;
        } else if (((Planet)target.getModel()).getPlanetGenerationSettings() != null) {
            discovery.rarity = ((Planet)target.getModel()).getPlanetGenerationSettings().rarity;
            discovery.discoveryPoints = ((Planet)target.getModel()).getPlanetGenerationSettings().discoveryPoints;
        } else {
            discovery.rarity = Discovery.Rarity.COMMON;
            discovery.discoveryPoints = 5;
        }
        return discovery;
    }

    public Discovery createDiscovery(SatelliteTarget target) {
        Discovery discovery = this.createBasicDiscovery(target);
        discovery.icon = "icon_inline_ship";
        discovery.classification = Discovery.Classification.SPACECRAFT;
        discovery.rarity = Discovery.Rarity.EPIC;
        discovery.discoveryPoints = 5 * (((Satellite)target.getModel()).getSatelliteGrid().vesselSize.ordinal() + 1);
        if (target.isStationary()) {
            discovery.starSystemId = AstraXApp.astraX.getScreen(SpaceScreen.class).getAstraxGame().getWorld().getSectorStream().getCurrentSector().getTileID();
        }
        return discovery;
    }

    public Discovery createDiscovery(AsteroidTarget target) {
        Discovery discovery = this.createBasicDiscovery(target);
        discovery.icon = "icon_inline_target_asteroid";
        discovery.starSystemId = AstraXApp.astraX.getScreen(SpaceScreen.class).getAstraxGame().getWorld().getSectorStream().getCurrentSector().getTileID();
        return discovery;
    }

    public Discovery createBasicDiscovery(Targetable target) {
        Discovery discovery = new Discovery();
        discovery.id = (int)System.currentTimeMillis();
        discovery.entityId = target.getID().get();
        discovery.name = AstraXApp.astraX.getRepositoryFactory().getDataManager().translateMarked(target.getName());
        discovery.icon = "icon_inline_questionmark";
        discovery.description = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class).translate("game_map_unknown_object_description");
        discovery.classification = this.getClassification(target);
        discovery.rarity = Discovery.Rarity.COMMON;
        discovery.discoveryPoints = 5;
        return discovery;
    }

    private Discovery.Classification getClassification(Targetable target) {
        if (target instanceof AsteroidTarget) {
            return Discovery.Classification.ASTEROID;
        }
        if (target instanceof BeltTarget) {
            return Discovery.Classification.BELT;
        }
        if (target instanceof SatelliteTarget) {
            return Discovery.Classification.SPACECRAFT;
        }
        return Discovery.Classification.OTHER;
    }
}

