/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.AbstractApplicationFactory;
import com.neutronio.astrax.app.UserProfile;
import com.neutronio.astrax.app.datapack.DataPack;
import com.neutronio.astrax.app.datapack.DataPackFactory;
import com.neutronio.astrax.app.datapack.DataPackSettings;
import com.neutronio.astrax.app.datapack.game.Game;
import com.neutronio.astrax.app.datapack.game.GameSettings;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.io.json.config.JSONToGameSettings;
import com.neutronio.astrax.util.date.Timespan;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GameFactory
extends AbstractApplicationFactory
implements GenericFactory<Game, GameSettings> {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());

    public GameFactory(AstraXApp game) {
        super(game);
    }

    @Override
    public Game create(GameSettings gameSettings) {
        return null;
    }

    public Game createGame(UserProfile userProfile, GameSettings gameSettings) {
        this.logger.log(Level.INFO, "Creating new Game \"{0}\", seed: {1}", new Object[]{gameSettings.gameName, gameSettings.seed});
        DataPackFactory dataPackFactory = this.gameContainer.getAppFactoryByClass(DataPackFactory.class);
        Game game = new Game();
        game.setGameSettings(gameSettings);
        game.addLoadedDataPack(AstraXApp.astraX.getCoreDataPack());
        AstraXApp.astraX.getCoreDataPack().setGame(game);
        for (DataPackSettings settings : game.getGameSettings().dataPackList) {
            DataPack dataPack = dataPackFactory.create(settings);
            dataPack.setGame(game);
            game.addLoadedDataPack(dataPack);
        }
        this.logger.log(Level.INFO, "Creating directory for game");
        FileHandle gameDirectory = Gdx.files.local(userProfile.resourcePath).child("saves").child(gameSettings.gameName);
        gameDirectory.mkdirs();
        JSONToGameSettings jsonToGameSettings = this.gameContainer.getRepositoryFactory().getDataManager().getConverter(JSONToGameSettings.class);
        this.gameContainer.getRepositoryFactory().save(gameSettings, jsonToGameSettings, gameDirectory.path(), "game.json", true);
        game.setGameDirectory(gameDirectory);
        return game;
    }

    public Game loadGame(FileHandle gameDirectory) {
        Game game = new Game();
        game.addLoadedDataPack(AstraXApp.astraX.getCoreDataPack());
        JSONToGameSettings jsonToGameSettings = this.gameContainer.getRepositoryFactory().getDataManager().getConverter(JSONToGameSettings.class);
        FileHandle gameSettingsFile = gameDirectory.child("game.json");
        try {
            GameSettings settings = (GameSettings)this.gameContainer.getRepositoryFactory().load(gameSettingsFile.path(), jsonToGameSettings);
            settings.lastPlayed = new Date();
            Timespan timespan = new Timespan(settings.lastPlayed.getTime() / 60L - settings.lastPlayed.getTime() / 60L);
            settings.timePlayed.add(timespan);
            game.setGameSettings(settings);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AstraXApp.astraX.getCoreDataPack().setGame(game);
        game.setGameDirectory(gameDirectory);
        return game;
    }
}

