/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.mechanics.resources;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.DataPack;
import com.neutronio.astrax.app.datapack.game.GameLogic;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.ResourceDeposit;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Mineable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Module;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining.MiningDrill;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining.MiningSystem;
import com.neutronio.astrax.app.generator.ProbabilitySetGenerator;
import com.neutronio.astrax.app.repository.ResourceRepository;
import com.neutronio.astrax.util.sequences.NumberGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceCollectionManager
extends GameLogic {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private NumberGenerator numberGenerator;
    private ProbabilitySetGenerator generator = new ProbabilitySetGenerator();

    public ResourceCollectionManager(DataPack dataPack) {
        super(dataPack);
        this.numberGenerator = new NumberGenerator(System.currentTimeMillis());
    }

    @Deprecated
    public List<Item<Resource>> mineFrom(MiningDrill drill, ResourceDeposit resourceDeposit, Satellite satellite) {
        if (resourceDeposit == null || !satellite.hasSystem(CargoSystem.class)) {
            return new ArrayList<Item<Resource>>();
        }
        CargoSystem cargoSystem = satellite.getSystem(CargoSystem.class);
        ArrayList<Item<Resource>> result = new ArrayList<Item<Resource>>();
        String resourceID = this.generator.generate(this.numberGenerator, resourceDeposit.getResourceSettings().getResources());
        int minedResources = resourceDeposit.mineResourceVia(drill);
        Item<Resource> item = this.getItem(resourceID, minedResources);
        cargoSystem.add(item);
        result.add(item);
        this.logger.log(Level.FINE, "Resource gathered: " + resourceID);
        return result;
    }

    public List<Item<Resource>> mineItemsFrom(Mineable mineable, Satellite satellite) {
        if (!(mineable.hasResources() || mineable.hasResourceDeposit() || satellite.hasSystem(CargoSystem.class))) {
            return new ArrayList<Item<Resource>>();
        }
        CargoSystem cargoSystem = satellite.getSystem(CargoSystem.class);
        Module drillModule = satellite.getSystem(MiningSystem.class).getMiningDrills().get(0);
        MiningDrill drill = drillModule.getFunctionality(MiningDrill.class);
        ArrayList<Item<Resource>> result = new ArrayList<Item<Resource>>();
        String resourceID = this.generator.generate(this.numberGenerator, mineable.getResourceDeposit().getResourceSettings().getResources());
        int minedResources = mineable.getResourceDeposit().mineResourceVia(drill);
        Item<Resource> item = this.getItem(resourceID, minedResources);
        cargoSystem.add(item.copy());
        result.add(item);
        return result;
    }

    private Item<Resource> getItem(String resourceID, int amount) {
        ResourceRepository resourceRepository = AstraXApp.astraX.getRepository(ResourceRepository.class);
        Resource resource = (Resource)resourceRepository.find(resourceID);
        if (resource == null) {
            throw new AstraXException(AstraXException.ErrorCode.E3000, "Resource ID: " + resourceID);
        }
        Item<Resource> item = new Item<Resource>();
        item.setAmount(amount);
        item.setObject(resource);
        item.setCategory(resource.getCategory());
        item.setIcon(resource.getIcon());
        item.setName(resource.getName());
        item.withBasePrice(resource.getValue());
        item.setWeight(resource.getWeight());
        return item;
    }
}

