/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.mechanics.resources;

import com.neutronio.astrax.app.datapack.game.mechanics.resources.ResourceDepositSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining.MiningDrill;
import java.io.Serializable;

public class ResourceDeposit
implements Serializable {
    private static final long serialVersionUID = -1448671755723183618L;
    protected transient ResourceDepositSettings resourceDepositSettings;
    protected String traitID;
    protected String name;
    protected int depositSize = 100;
    protected int maxDepositSize = 100;
    protected float miningDifficulty = 1.0f;

    public int mineResourceVia(MiningDrill drill) {
        int gathered = Math.round(drill.getGatheringYield() / this.getMiningDifficulty());
        if (gathered >= this.depositSize) {
            gathered = this.depositSize;
            this.depositSize = 0;
        } else {
            this.depositSize -= gathered;
        }
        return gathered;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getTraitID() {
        return this.traitID;
    }

    public void setTraitID(String traitID) {
        this.traitID = traitID;
    }

    public ResourceDepositSettings getResourceSettings() {
        return this.resourceDepositSettings;
    }

    public void setResourceSettings(ResourceDepositSettings resourceDepositSettings) {
        this.resourceDepositSettings = resourceDepositSettings;
    }

    public float getRemainingDeposit() {
        return (float)this.depositSize / (float)this.maxDepositSize;
    }

    public int getMaxDepositSize() {
        return this.maxDepositSize;
    }

    public void setMaxDepositSize(int maxDepositSize) {
        this.maxDepositSize = maxDepositSize;
    }

    public int getDepositSize() {
        return this.depositSize;
    }

    public void setDepositSize(int depositSize) {
        this.depositSize = depositSize;
    }

    public float getMiningDifficulty() {
        return this.miningDifficulty;
    }

    public void setMiningDifficulty(float miningDifficulty) {
        this.miningDifficulty = miningDifficulty;
    }
}

