/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.PositionController;
import com.neutronio.astrax.app.generator.NameSpace;
import com.neutronio.astrax.util.AstraXUtil;
import com.neutronio.astrax.util.TargetSettings;

public abstract class AbstractTarget<MODEL, GRAPHICS extends Actor>
implements Targetable<MODEL, GRAPHICS> {
    protected EntityID id = null;
    protected NameSpace nameSpace;
    protected TargetSettings targetSettings;
    protected Body physicsBody;
    protected MODEL model = null;
    protected GRAPHICS graphics = null;
    protected PositionController positionController = null;
    protected Vector2 globalPosition = new Vector2();

    protected AbstractTarget(EntityID id) {
        this.id = id;
    }

    protected AbstractTarget(EntityID id, MODEL model, GRAPHICS graphics) {
        this(id, null, model, graphics);
    }

    protected AbstractTarget(EntityID id, NameSpace nameSpace, MODEL model, GRAPHICS graphics) {
        this.nameSpace = nameSpace;
        this.id = id;
        this.model = model;
        this.graphics = graphics;
        ((Actor)this.graphics).setOrigin(1);
        ((Actor)this.graphics).setUserObject(this);
    }

    public NameSpace getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(NameSpace nameSpace) {
        this.nameSpace = nameSpace;
    }

    @Override
    public void setDiscoverableSettings(TargetSettings settings) {
        this.targetSettings = settings;
    }

    @Override
    public TargetSettings getDiscoverableSettings() {
        return this.targetSettings;
    }

    @Override
    public String getName() {
        return this.id.get();
    }

    @Override
    public EntityID getID() {
        return this.id;
    }

    @Override
    public String getArchType() {
        return "fix me";
    }

    @Override
    public String getSubType() {
        return "fix me";
    }

    @Override
    public MODEL getModel() {
        return this.model;
    }

    @Override
    public GRAPHICS getGraphics() {
        return this.graphics;
    }

    @Override
    public float getWorldPositionX() {
        return this.globalPosition.x;
    }

    @Override
    public float getWorldPositionY() {
        return this.globalPosition.y;
    }

    @Override
    public Vector2 getWorldPosition() {
        this.globalPosition.set(0.0f, 0.0f);
        AstraXUtil.getWorldPosition(this.globalPosition, this.getGraphics());
        return this.globalPosition.cpy();
    }

    @Override
    public void update(float delta, float systemTime) {
        this.globalPosition.set(0.0f, 0.0f);
        AstraXUtil.getWorldPosition(this.globalPosition, this.getGraphics());
    }

    @Override
    public PositionController getPositionController() {
        return this.positionController;
    }

    @Override
    public void setPositionController(PositionController positionController) {
        this.positionController = positionController;
    }
}

