/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world;

import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.AbstractTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.Asteroid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Orbit;
import com.neutronio.astrax.app.generator.NameSpace;
import com.neutronio.astrax.gfx.AsteroidGraphics;

public class AsteroidTarget
extends AbstractTarget<Asteroid, AsteroidGraphics> {
    public AsteroidTarget(EntityID id) {
        super(id);
    }

    public AsteroidTarget(EntityID id, Asteroid asteroid, AsteroidGraphics asteroidGraphics) {
        super(id, asteroid, asteroidGraphics);
    }

    public AsteroidTarget(EntityID id, NameSpace nameSpace, Asteroid asteroid, AsteroidGraphics asteroidGraphics) {
        super(id, nameSpace, asteroid, asteroidGraphics);
    }

    @Override
    public void update(float delta, float systemTime) {
        super.update(delta, systemTime);
        this.getPositionController().update(delta);
        if (this.getPositionController() instanceof Orbit) {
            Orbit orbit = (Orbit)this.getPositionController();
            ((AsteroidGraphics)this.getGraphics()).setPosition(orbit.getCurrentX(systemTime), orbit.getCurrentY(systemTime));
        }
        ((AsteroidGraphics)this.getGraphics()).setDiscoveredFactor(1.0f);
        ((AsteroidGraphics)this.getGraphics()).setResourceFactor(((Asteroid)this.getModel()).getResourceDeposit().getRemainingDeposit());
    }

    @Override
    public String getName() {
        return ((Asteroid)this.model).getSettings().name;
    }

    @Override
    public void select() {
        ((AsteroidGraphics)this.getGraphics()).select();
    }

    @Override
    public void deselect() {
        ((AsteroidGraphics)this.getGraphics()).deselect();
    }
}

