/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.game.world.NPCFactory;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.AsteroidFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetGenerationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.OrbitalBeltFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.PlanetCreationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.PlanetFactory;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.Generator;
import com.neutronio.astrax.app.generator.ProducedBy;
import com.neutronio.astrax.app.generator.TargetFactory;
import com.neutronio.astrax.app.repository.Tagged;
import com.neutronio.astrax.util.TargetSettings;
import java.util.List;

public class AstraXTargetFactory
extends AbstractFactory
implements Generator<Targetable, TargetSettings> {
    public AstraXTargetFactory() {
    }

    public AstraXTargetFactory(DataContext dataContext) {
        super(dataContext);
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        AstraXApp.astraX.getFactoryByClass(AsteroidFactory.class).setSeed(seed);
        AstraXApp.astraX.getFactoryByClass(OrbitalBeltFactory.class).setSeed(seed);
        AstraXApp.astraX.getFactoryByClass(PlanetFactory.class).setSeed(seed);
        AstraXApp.astraX.getFactoryByClass(SatelliteFactory.class).setSeed(seed);
        AstraXApp.astraX.getFactoryByClass(NPCFactory.class).setSeed(seed);
    }

    @Override
    public Targetable generate(TargetSettings targetSettings) {
        Object settingsObject = this.resolveSettingsObject(targetSettings);
        TargetFactory factory = this.getFactoryForObject(settingsObject);
        Targetable target = this.wrapAndCreateTarget(settingsObject, factory);
        target.setDiscoverableSettings(targetSettings);
        return target;
    }

    public TargetFactory getFactoryForObject(Object settingsObject) {
        ProducedBy annotation = settingsObject.getClass().getAnnotation(ProducedBy.class);
        if (annotation == null) {
            throw new AstraXException(AstraXException.ErrorCode.E3000, "Factory for '" + settingsObject.getClass() + "' could not be found. The settings object currently requires the ProducedBy annotation which refers to an instance of TargetFactory that is processing the settings object into a target.");
        }
        AbstractFactory factory = AstraXApp.astraX.getFactoryByClass(annotation.value());
        return (TargetFactory)((Object)factory);
    }

    public Object resolveSettingsObject(TargetSettings targetSettings) {
        if (targetSettings.id != null) {
            Object settingsObject = this.dataContext.findDataByID(targetSettings.id);
            if (settingsObject == null) {
                throw new AstraXException(AstraXException.ErrorCode.E3000, targetSettings.id);
            }
            return settingsObject;
        }
        if (targetSettings.tags != null) {
            List<Tagged> taggedSettings = targetSettings.exclude != null ? AstraXApp.astraX.getRepositoryFactory().getDataManager().findDataByTags(targetSettings.tags, targetSettings.exclude) : this.dataContext.findDataByTags(targetSettings.tags);
            Tagged settingsObject = this.numberGenerator.getRandomEntry(taggedSettings);
            if (settingsObject == null) {
                throw new AstraXException(AstraXException.ErrorCode.E3000, targetSettings.id);
            }
            return settingsObject;
        }
        if (targetSettings.set != null) {
            String objectID = this.setGenerator.generate(this.numberGenerator, targetSettings.set);
            Object settingsObject = this.dataContext.findDataByID(objectID);
            if (settingsObject == null) {
                throw new AstraXException(AstraXException.ErrorCode.E3000, objectID);
            }
            return settingsObject;
        }
        if (targetSettings.orbitalBeltSettings != null) {
            return targetSettings.orbitalBeltSettings;
        }
        throw new AstraXException(AstraXException.ErrorCode.E2003, "Json Field 'id', 'tags', 'set' or 'orbitalBeltSettings' need to be declared in data entry! They can't be all missing. In the data, either use a valid id, tag, set or belt settings.");
    }

    public Targetable wrapAndCreateTarget(Object targetSettings, TargetFactory factory) {
        if (factory instanceof PlanetFactory) {
            if (!(targetSettings instanceof PlanetGenerationSettings) && !(targetSettings instanceof PlanetCreationSettings)) {
                throw new AstraXException(AstraXException.ErrorCode.E3104, "\nExpected: \n\t" + PlanetGenerationSettings.class + " or \n\t" + PlanetCreationSettings.class + "\nProvided: \n\t" + targetSettings.getClass());
            }
            PlanetFactory.CelestialSettings celestialSettings = new PlanetFactory.CelestialSettings();
            celestialSettings.planetGenerationSettings = targetSettings instanceof PlanetGenerationSettings ? (PlanetGenerationSettings)targetSettings : null;
            celestialSettings.planetCreationSettings = targetSettings instanceof PlanetCreationSettings ? (PlanetCreationSettings)targetSettings : null;
            return factory.createTarget(celestialSettings);
        }
        try {
            return factory.createTarget(targetSettings);
        }
        catch (ClassCastException ex) {
            throw new AstraXException(AstraXException.ErrorCode.E3103, "Ensure the Factory API of '" + factory.getClass().getCanonicalName() + "' is used ", ex);
        }
    }
}

