/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world;

import com.badlogic.gdx.math.Vector2;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.AbstractTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.PositionController;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.EllipsoidOrbit;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Orbit;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Planet;
import com.neutronio.astrax.app.generator.NameSpace;
import com.neutronio.astrax.gfx.entities.PlanetGraphics;

public class CelestialTarget
extends AbstractTarget<Planet, PlanetGraphics> {
    private Vector2 temp_Angle = new Vector2();

    protected CelestialTarget(EntityID id) {
        super(id);
    }

    public CelestialTarget(EntityID id, NameSpace nameSpace, Planet planet, PlanetGraphics graphics) {
        super(id, nameSpace, planet, graphics);
    }

    @Override
    public void update(float delta, float systemTime) {
        super.update(delta, systemTime);
        PositionController positionController = this.getPositionController();
        positionController.update(delta);
        if (positionController instanceof EllipsoidOrbit) {
            EllipsoidOrbit orbit = (EllipsoidOrbit)positionController;
            ((PlanetGraphics)this.getGraphics()).setPosition(orbit.getCurrentX(systemTime), orbit.getCurrentY(systemTime));
            this.temp_Angle.set(this.getWorldPositionX(), this.getWorldPositionY());
            if (((PlanetGraphics)this.graphics).hasShadowMask()) {
                ((PlanetGraphics)this.getGraphics()).faceTo((this.temp_Angle.angleDeg() + 180.0f) % 360.0f);
            }
        } else if (positionController instanceof Orbit) {
            Orbit orbit = (Orbit)positionController;
            ((PlanetGraphics)this.getGraphics()).setPosition(orbit.getCurrentX(systemTime), orbit.getCurrentY(systemTime));
            this.temp_Angle.set(this.getWorldPositionX(), this.getWorldPositionY());
            if (((PlanetGraphics)this.graphics).hasShadowMask()) {
                ((PlanetGraphics)this.getGraphics()).faceTo((this.temp_Angle.angleDeg() + 180.0f) % 360.0f);
            }
        }
    }

    @Override
    public void select() {
        ((PlanetGraphics)this.getGraphics()).select();
    }

    @Override
    public void deselect() {
        ((PlanetGraphics)this.getGraphics()).deselect();
    }

    @Override
    public String getName() {
        return ((Planet)this.model).getName();
    }

    public String toString() {
        return "CelestialTarget{id=" + this.id + "name=" + ((Planet)this.model).getName() + '}';
    }
}

