/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world;

import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.NameFactory;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.ItemCreationSettings;
import com.neutronio.astrax.app.datapack.game.world.ItemGenerationSettings;
import com.neutronio.astrax.app.datapack.game.world.NPCTrader;
import com.neutronio.astrax.app.datapack.game.world.galaxy.MerchantCreationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.MerchantGenerationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.InventoryUtils;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.Generator;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.app.repository.ResourceRepository;
import com.neutronio.astrax.util.AstraXUtil;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class NPCFactory
extends AbstractFactory
implements Generator<MerchantCreationSettings, MerchantGenerationSettings>,
GenericFactory<NPCTrader, MerchantCreationSettings> {
    protected NameFactory nameFactory;
    protected ResourceRepository resourceRepository;

    public NPCFactory() {
    }

    public NPCFactory(DataContext dataContext) {
        super(dataContext);
        this.nameFactory = dataContext.getFactory(NameFactory.class);
        this.resourceRepository = dataContext.getRepository(ResourceRepository.class);
    }

    @Override
    public MerchantCreationSettings generate(MerchantGenerationSettings generationSettings) {
        MerchantCreationSettings creationSettings = new MerchantCreationSettings();
        if (generationSettings.nameGenPattern == null) {
            creationSettings.name = this.generateName();
        } else {
            String genPattern = this.numberGenerator.getRandomEntry(generationSettings.nameGenPattern);
            creationSettings.name = this.nameFactory.createName(this.numberGenerator, genPattern);
        }
        creationSettings.traderTypeName = generationSettings.traderTypeName;
        creationSettings.startMoney = this.numberGenerator.getRandomFloat(generationSettings.maxStarterMoney, generationSettings.minStarterMoney);
        creationSettings.buyPriceModifier = this.numberGenerator.getRandomFloat(generationSettings.maxBuyPriceModifier, generationSettings.minBuyPriceModifier);
        creationSettings.sellPriceModifier = this.numberGenerator.getRandomFloat(generationSettings.maxSellPriceModifier, Math.min(creationSettings.buyPriceModifier, generationSettings.minSellPriceModifier));
        List<String> randomItems = this.setGenerator.generateListNoDuplicates(this.numberGenerator, generationSettings.buyItems, generationSettings.buyItems.size());
        creationSettings.buyItems.addAll(randomItems);
        int randomStack = this.numberGenerator.getRandomInteger(7, 5);
        List<ItemGenerationSettings> generatedItems = this.setGenerator.generateListNoDuplicates(this.numberGenerator, generationSettings.sellItems, randomStack);
        for (ItemGenerationSettings generatedItem : generatedItems) {
            ItemCreationSettings createdItem = this.generateItem(generatedItem);
            creationSettings.sellItems.add(createdItem);
        }
        return creationSettings;
    }

    public ItemCreationSettings generateItem(ItemGenerationSettings generationSettings) {
        ItemCreationSettings creationSettings = new ItemCreationSettings();
        creationSettings.amount = this.numberGenerator.getRandomFloat(generationSettings.maxAmount, generationSettings.minAmount);
        creationSettings.resourceID = generationSettings.resourceID;
        return creationSettings;
    }

    public NPCTrader create(MerchantCreationSettings creationSettings, CargoSystem cargoSystem) {
        this.logger.fine("Creating Merchant with current seed " + this.numberGenerator.getSeed());
        NPCTrader npc = new NPCTrader(cargoSystem.getMaxWeight());
        npc.setMerchantCreationSettings(creationSettings);
        npc.setCurrentMoney(creationSettings.startMoney);
        npc.setBuyPriceModifier(creationSettings.buyPriceModifier);
        npc.setSellPriceModifier(creationSettings.sellPriceModifier);
        for (ItemCreationSettings itemSettings : creationSettings.sellItems) {
            Resource resource = (Resource)this.resourceRepository.find(itemSettings.resourceID);
            Item<Resource> item = InventoryUtils.resourceToItem(resource, itemSettings.amount);
            npc.getSells().add(item);
        }
        return npc;
    }

    @Override
    public NPCTrader create(MerchantCreationSettings creationSettings) {
        this.logger.fine("Creating Merchant with current seed " + this.numberGenerator.getSeed());
        NPCTrader npc = new NPCTrader();
        npc.setMerchantCreationSettings(creationSettings);
        npc.setCurrentMoney(creationSettings.startMoney);
        npc.setBuyPriceModifier(creationSettings.buyPriceModifier);
        npc.setSellPriceModifier(creationSettings.sellPriceModifier);
        for (ItemCreationSettings itemSettings : creationSettings.sellItems) {
            Resource resource = (Resource)this.resourceRepository.find(itemSettings.resourceID);
            Item<Resource> item = InventoryUtils.resourceToItem(resource, itemSettings.amount);
            npc.getSells().add(item);
        }
        return npc;
    }

    public void restockMerchant(NPCTrader merchant) {
        long minutes;
        long l = minutes = merchant.getLastRestock() == null ? (long)merchant.getRestockInterval() : AstraXUtil.getDateDiff(merchant.getLastRestock(), new Date(), TimeUnit.MINUTES);
        if (minutes >= (long)merchant.getRestockInterval()) {
            for (ItemCreationSettings itemSettings : merchant.getMerchantCreationSettings().sellItems) {
                Resource resource = (Resource)this.resourceRepository.find(itemSettings.resourceID);
                Item<Resource> item = InventoryUtils.resourceToItem(resource, itemSettings.amount);
                merchant.getSells().add(item);
            }
            merchant.onRestock();
        }
    }
}

