/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world;

import com.neutronio.astrax.app.datapack.game.Trader;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.Merchant;
import com.neutronio.astrax.app.datapack.game.world.galaxy.MerchantCreationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Cargobay;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.MultiStackInventory;
import java.util.Date;

public class NPCTrader
implements Trader {
    private MerchantCreationSettings merchantCreationSettings;
    private Cargobay<Resource> sells = new Cargobay(new CargoSettings(2.0f));
    private int restockInterval;
    private Merchant merchant = new Merchant();

    public NPCTrader() {
    }

    public NPCTrader(float totalCargoSystemCapacity) {
        this.sells = new Cargobay(new CargoSettings(totalCargoSystemCapacity));
    }

    public Merchant getMerchant() {
        return this.merchant;
    }

    public void setMerchant(Merchant merchant) {
        this.merchant = merchant;
    }

    public MerchantCreationSettings getMerchantCreationSettings() {
        return this.merchantCreationSettings;
    }

    public void setMerchantCreationSettings(MerchantCreationSettings merchantCreationSettings) {
        this.merchantCreationSettings = merchantCreationSettings;
    }

    public float getCurrentMoney() {
        return this.merchant.currentMoney;
    }

    public void setCurrentMoney(float currentMoney) {
        this.merchant.currentMoney = currentMoney;
    }

    public Date getLastRestock() {
        return this.merchant.lastRestock;
    }

    public void setLastRestock(Date lastRestock) {
        this.merchant.lastRestock = lastRestock;
    }

    public int getRestockInterval() {
        return this.restockInterval;
    }

    public void setRestockInterval(int restockInterval) {
        this.restockInterval = restockInterval;
    }

    public float getSellPriceModifier() {
        return this.merchant.sellPriceModifier;
    }

    public void setSellPriceModifier(float sellPriceModifier) {
        this.merchant.sellPriceModifier = sellPriceModifier;
    }

    public float getBuyPriceModifier() {
        return this.merchant.buyPriceModifier;
    }

    public void setBuyPriceModifier(float buyPriceModifier) {
        this.merchant.buyPriceModifier = buyPriceModifier;
    }

    public void onRestock() {
        this.merchant.lastRestock = new Date();
    }

    public Cargobay<Resource> getSells() {
        return this.sells;
    }

    @Override
    public float getMoney() {
        return this.merchant.currentMoney;
    }

    @Override
    public void changeMoney(float money) {
        this.merchant.currentMoney += money;
    }

    @Override
    public String getName() {
        return this.merchantCreationSettings.name;
    }

    @Override
    public float getMaxWeight() {
        return this.getSells().getMaxWeight();
    }

    @Override
    public MultiStackInventory<Resource> getInventory() {
        return this.sells.getInventory().copy();
    }
}

