/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world;

import com.badlogic.gdx.math.Vector2;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.AbstractTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.NavigationBookmark;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.EllipsoidOrbit;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StaticOrbit;
import com.neutronio.astrax.gfx.NavigationGraphics;
import com.neutronio.astrax.util.AstraXUtil;

public class NavTarget
extends AbstractTarget<NavigationBookmark, NavigationGraphics> {
    public static int FOLLOW_MODE_TARGET = 0;
    public static int FOLLOW_MODE_POSITION = 1;
    private int followMode = -1;
    private NavigationBookmark parentBookmark;
    private Targetable followedTarget;
    private Vector2 followedPosition = new Vector2();

    public NavTarget(EntityID id) {
        super(id);
    }

    public void setParentBookmark(NavigationBookmark parentBookmark) {
        this.parentBookmark = parentBookmark;
    }

    public NavigationBookmark getParentBookmark() {
        return this.parentBookmark;
    }

    public static NavTarget getDummyStaticTarget(EntityID id, float x, float y) {
        NavTarget target = new NavTarget(id);
        StaticOrbit orbit = new StaticOrbit();
        orbit.setX(x);
        orbit.setY(y);
        target.setPositionController(orbit);
        return target;
    }

    public static NavTarget getDummyOrbitTarget(EntityID id, float width, float height, float offsetY, float offsetX) {
        NavTarget target = new NavTarget(id);
        EllipsoidOrbit orbit = new EllipsoidOrbit();
        orbit.setWidth(width);
        orbit.setHeight(height);
        orbit.setOffsetX(offsetX);
        orbit.setOffsetY(offsetY);
        orbit.setVelocity(1.5f);
        target.setPositionController(orbit);
        return target;
    }

    public void setModel(NavigationBookmark model) {
        this.model = model;
    }

    public void setGraphics(NavigationGraphics graphics) {
        this.graphics = graphics;
    }

    public void setFollowedTarget(Targetable followedTarget) {
        this.followedTarget = followedTarget;
    }

    public void setFollowMode(int followMode) {
        this.followMode = followMode;
    }

    public int getFollowMode() {
        return this.followMode;
    }

    public void setFollowedPosition(float x, float y) {
        this.followedPosition.set(x, y);
    }

    public void setFollowedPosition(Vector2 followedPosition) {
        this.followedPosition = followedPosition;
    }

    private void updatePosition() {
        this.globalPosition.set(0.0f, 0.0f);
        if (this.followMode == FOLLOW_MODE_TARGET) {
            AstraXUtil.getWorldPosition(this.globalPosition, this.followedTarget.getGraphics());
        } else {
            AstraXUtil.getWorldPosition(this.globalPosition, this.getGraphics());
        }
    }

    @Override
    public void update(float delta, float systemTime) {
        super.update(delta, systemTime);
        this.updatePosition();
    }

    @Override
    public float getWorldPositionX() {
        if (this.followMode == FOLLOW_MODE_TARGET && this.followedTarget != null) {
            return this.followedTarget.getWorldPositionX();
        }
        return this.followedPosition.x;
    }

    @Override
    public float getWorldPositionY() {
        if (this.followMode == FOLLOW_MODE_TARGET && this.followedTarget != null) {
            return this.followedTarget.getWorldPositionY();
        }
        return this.followedPosition.y;
    }

    @Override
    public Vector2 getWorldPosition() {
        if (this.followMode == FOLLOW_MODE_TARGET && this.followedTarget != null) {
            return this.followedTarget.getWorldPosition();
        }
        return this.followedPosition.cpy();
    }

    @Override
    public void select() {
    }

    @Override
    public void deselect() {
    }
}

