/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.util.AstraXUtil;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class OrbitRing {
    public int width;
    public int height;
    public int thickness = 10;
    public Color[] colors;

    public OrbitRing(int width, int height, int thickness, Color color, int ringCount) {
        this.width = width;
        this.height = height;
        this.thickness = thickness;
        this.colors = AstraXUtil.shuffleColors(ringCount, 0.3f, color);
    }

    public void render(ShapeDrawer shapeDrawer, float x, float y, float scaleX, float scaleY, float delta) {
        float thicknessPerLine = (float)this.thickness / (float)this.colors.length * scaleX;
        shapeDrawer.setDefaultLineWidth(thicknessPerLine);
        int i2 = 0;
        for (Color color : this.colors) {
            shapeDrawer.setColor(color.r, color.g, color.b, 0.5f);
            shapeDrawer.ellipse(x + (float)this.width / 2.0f, y + (float)this.height / 2.0f, (float)this.width / 2.0f * scaleX + thicknessPerLine * (float)i2, (float)this.height / 2.0f * scaleY + thicknessPerLine * (float)i2);
            ++i2;
        }
    }
}

