/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.World;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.game.world.AsteroidTarget;
import com.neutronio.astrax.app.datapack.game.world.BeltTarget;
import com.neutronio.astrax.app.datapack.game.world.CelestialTarget;
import com.neutronio.astrax.app.datapack.game.world.PhysicsSettings;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Planet;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.GenericFactory;
import java.util.List;

public class PhysicsFactory
extends AbstractFactory
implements GenericFactory<Body, PhysicsSettings> {
    private static BodyDef tempBodyDef = new BodyDef();
    private static FixtureDef tempFixtureDef = new FixtureDef();
    private World physicsWorld;

    public PhysicsFactory(World physicsWorld) {
        this.physicsWorld = physicsWorld;
    }

    public PhysicsFactory(DataContext dataContext) {
        super(dataContext);
    }

    public World getPhysicsWorld() {
        return this.physicsWorld;
    }

    public void setPhysicsWorld(World physicsWorld) {
        this.physicsWorld = physicsWorld;
    }

    @Override
    public Body create(PhysicsSettings physicsSettings) {
        physicsSettings.bodyDef.applyTo(tempBodyDef);
        Body body = this.physicsWorld.createBody(tempBodyDef);
        body.setUserData(physicsSettings.bodyDef.userData);
        for (PhysicsSettings.PhysicsFixtureSettings fixtureSettings : physicsSettings.fixtures) {
            fixtureSettings.applyTo(tempFixtureDef);
            Fixture fixture = body.createFixture(tempFixtureDef);
            fixture.setUserData(fixtureSettings.userData);
        }
        return body;
    }

    public void destroy(Body body) {
        this.physicsWorld.destroyBody(body);
    }

    public void destroyPhysics(StarSystem starSystem) {
    }

    public PhysicsSettings createPhysicsSettings(AsteroidTarget asteroid) {
        PhysicsSettings physicsSettings = new PhysicsSettings();
        physicsSettings.bodyDef.type = BodyDef.BodyType.DynamicBody;
        physicsSettings.bodyDef.position.set(asteroid.getWorldPosition().x, asteroid.getWorldPosition().y);
        physicsSettings.bodyDef.userData = asteroid;
        physicsSettings.bodyDef.linearDamping = 0.1f;
        physicsSettings.bodyDef.angularDamping = 0.1f;
        PhysicsSettings.PhysicsFixtureSettings baseFixture = new PhysicsSettings.PhysicsFixtureSettings();
        PolygonShape boxShape = new PolygonShape();
        boxShape.setAsBox(10.0f, 10.0f);
        baseFixture.restitution = 0.1f;
        baseFixture.shape = boxShape;
        baseFixture.density = 0.4f;
        baseFixture.userData = asteroid;
        physicsSettings.fixtures.add(baseFixture);
        return physicsSettings;
    }

    public PhysicsSettings createPhysicsSettings(CelestialTarget planet) {
        PhysicsSettings physicsSettings = new PhysicsSettings();
        physicsSettings.bodyDef.type = BodyDef.BodyType.StaticBody;
        physicsSettings.bodyDef.position.set(planet.getWorldPosition().x, planet.getWorldPosition().y);
        physicsSettings.bodyDef.fixedRotation = true;
        physicsSettings.bodyDef.userData = planet;
        PhysicsSettings.PhysicsFixtureSettings baseFixture = new PhysicsSettings.PhysicsFixtureSettings();
        CircleShape circleShape = new CircleShape();
        circleShape.setRadius(25.6f * ((Planet)planet.getModel()).getPlanetScale());
        baseFixture.shape = circleShape;
        baseFixture.isSensor = true;
        baseFixture.userData = planet;
        physicsSettings.fixtures.add(baseFixture);
        physicsSettings.fixtures.add(baseFixture);
        return physicsSettings;
    }

    public PhysicsSettings createPhysicsSettings(SatelliteTarget satellite) {
        PhysicsSettings physicsSettings = new PhysicsSettings();
        physicsSettings.bodyDef.position.set(satellite.getWorldPosition().x, satellite.getWorldPosition().y);
        physicsSettings.bodyDef.userData = satellite;
        if (!satellite.isStationary()) {
            physicsSettings.bodyDef.type = BodyDef.BodyType.DynamicBody;
            physicsSettings.bodyDef.linearDamping = 0.01f;
            physicsSettings.bodyDef.angularDamping = 0.1f;
        } else {
            physicsSettings.bodyDef.type = BodyDef.BodyType.StaticBody;
        }
        SatelliteGrid satelliteGrid = ((Satellite)satellite.getModel()).getSatelliteGrid();
        for (int x = 0; x < satelliteGrid.getData().getWidth() + 1; ++x) {
            for (int y = 0; y < satelliteGrid.getData().getHeight() + 1; ++y) {
                SatelliteGrid.SatelliteGridSettings settings = satelliteGrid.getData().get(x, y);
                if (settings == null) continue;
                if (settings.module == null) {
                    throw new AstraXException(AstraXException.ErrorCode.E0001, "modules");
                }
                PhysicsSettings.PhysicsFixtureSettings baseFixture = new PhysicsSettings.PhysicsFixtureSettings();
                PolygonShape boxShape = new PolygonShape();
                boxShape.setAsBox(32.0f, 32.0f, new Vector2(x * 32, y * 32), 0.0f);
                baseFixture.shape = boxShape;
                baseFixture.restitution = 0.1f;
                baseFixture.density = 0.2f;
                baseFixture.friction = 0.2f;
                baseFixture.userData = settings.module;
                physicsSettings.fixtures.add(baseFixture);
            }
        }
        return physicsSettings;
    }

    public void createPhysics(StarSystem starSystem) {
        for (Targetable targetable : starSystem.getSystemMembers()) {
            this.createPhysics(targetable);
        }
    }

    public void createPhysics(Targetable targetable) {
        if (targetable instanceof BeltTarget) {
            this.createPhysics((BeltTarget)targetable);
        }
        if (targetable instanceof AsteroidTarget) {
            this.create(this.createPhysicsSettings((AsteroidTarget)targetable));
        }
        if (targetable instanceof CelestialTarget) {
            this.create(this.createPhysicsSettings((CelestialTarget)targetable));
        }
        if (targetable instanceof SatelliteTarget) {
            this.create(this.createPhysicsSettings((SatelliteTarget)targetable));
        }
    }

    public List<Body> createPhysics(BeltTarget beltTarget) {
        return null;
    }
}

