/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.Trader;
import com.neutronio.astrax.app.datapack.game.mechanics.discovery.Trait;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.Discovery;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.MultiStackInventory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.TargetSorter;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoverySystem;
import com.neutronio.astrax.gfx.SatelliteGraphics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Player
implements Trader,
Serializable {
    private static final long serialVersionUID = -3388542344597494287L;
    private String name = "Frog";
    private DiscoveryTarget<SatelliteTarget> playerTarget = new DiscoveryTarget<Object>(null, null);
    private String satelliteEntityId;
    private int discoveryPoints = 0;
    private int chips = 0;
    @Deprecated
    private Map<String, Trait> discoveredPlanetTraits = new LinkedHashMap<String, Trait>();

    public DiscoveryTarget getDiscoveryTarget() {
        return this.playerTarget;
    }

    public String getsatelliteEntityId() {
        return this.satelliteEntityId;
    }

    public int getDiscoveryPoints() {
        return this.discoveryPoints;
    }

    public void setDiscoveryPoints(int discoveryPoints) {
        this.discoveryPoints = discoveryPoints;
    }

    public void setChips(int chips) {
        this.chips = chips;
    }

    public int getChips() {
        return this.chips;
    }

    public int getDiscoveredPlanetTraits() {
        return this.discoveredPlanetTraits.size();
    }

    public void addDiscoveryPointsFromTrait(Trait discovered) {
        if (discovered == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Trait is null!");
        }
        this.discoveryPoints += discovered.getDiscoveryPoints();
        if (this.discoveredPlanetTraits == null) {
            this.discoveredPlanetTraits = new LinkedHashMap<String, Trait>();
        }
        if (!this.discoveredPlanetTraits.containsKey(discovered.getId())) {
            this.discoveredPlanetTraits.put(discovered.getId(), discovered);
        }
    }

    public DiscoveryTarget getCurrentTarget() {
        return ((Satellite)((SatelliteTarget)this.playerTarget.target).getModel()).getSystem(DiscoverySystem.class).getTargetComputer().getCurrentTarget();
    }

    public List<TargetSorter.Target> getTargetsInRange() {
        return ((Satellite)((SatelliteTarget)this.playerTarget.target).getModel()).getTargetsInRange();
    }

    public void addDiscoveryPoints(int points) {
        this.discoveryPoints += points;
    }

    @Override
    public float getMoney() {
        return this.chips;
    }

    @Override
    public void changeMoney(float money) {
        this.chips = (int)((float)this.chips + money);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public float getMaxWeight() {
        CargoSystem cargoSystem = ((Satellite)this.getPlayerTarget().getModel()).getSystem(CargoSystem.class);
        return cargoSystem.getMaxWeight();
    }

    public float getEncumbrance() {
        CargoSystem cargoSystem = ((Satellite)this.getPlayerTarget().getModel()).getSystem(CargoSystem.class);
        return cargoSystem.getCurrentWeight() / cargoSystem.getMaxWeight();
    }

    @Override
    public MultiStackInventory<Resource> getInventory() {
        if (((Satellite)this.getPlayerTarget().getModel()).hasSystem(CargoSystem.class)) {
            CargoSystem cargoSystem = ((Satellite)this.getPlayerTarget().getModel()).getSystem(CargoSystem.class);
            return cargoSystem.getAccumulatedInventory();
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SatelliteTarget getPlayerTarget() {
        return (SatelliteTarget)this.playerTarget.target;
    }

    public void setPlayerTarget(Discovery discovery, SatelliteTarget playerTarget) {
        this.playerTarget.discovery = discovery;
        this.playerTarget.target = playerTarget;
    }

    public void setPlayerTarget(SatelliteTarget playerTarget) {
        this.playerTarget.target = playerTarget;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(((SatelliteTarget)this.playerTarget.target).id.get());
        oos.writeInt(this.discoveryPoints);
        oos.writeInt(this.chips);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        this.playerTarget = new DiscoveryTarget<Object>(null, null);
        this.satelliteEntityId = ois.readUTF();
        this.discoveryPoints = ois.readInt();
        this.chips = ois.readInt();
    }

    public void dispose() {
        ((SatelliteGraphics)((SatelliteTarget)this.playerTarget.target).graphics).dispose();
        ((SatelliteTarget)this.playerTarget.target).model = null;
        this.playerTarget = null;
    }
}

