/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world;

import com.badlogic.gdx.files.FileHandle;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.game.AbstractGameEventListener;
import com.neutronio.astrax.app.datapack.game.world.Player;
import com.neutronio.astrax.app.datapack.game.world.PlayerSettings;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.PropulsionSystem;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.gfx.SatelliteGraphics;
import com.neutronio.astrax.input.controller.PropulsionUserController;
import com.neutronio.astrax.io.AstraXFiles;

public class PlayerFactory
extends AbstractFactory
implements GenericFactory<Player, PlayerSettings> {
    protected SatelliteFactory satelliteFactory;

    public PlayerFactory() {
    }

    public PlayerFactory(DataContext dataContext) {
        super(dataContext);
    }

    @Deprecated
    public Player createPlayer(String playerName, SatelliteSettings playerSpacecraftSettings, AbstractGameEventListener spaceScreenGameEventListener) {
        throw new UnsupportedOperationException("Do not use this!");
    }

    @Override
    public Player create(PlayerSettings playerSettings) {
        this.logger.info("Creating Player...");
        Player player = new Player();
        player.setName(playerSettings.playerName);
        player.setDiscoveryPoints(player.getDiscoveryPoints());
        player.setChips(playerSettings.chips);
        return player;
    }

    public Player loadPlayer(String fileName, FileHandle gameDirectory) {
        Player player = (Player)AstraXApp.astraX.getAstraXFiles().readFileBinary(fileName, gameDirectory);
        player.setName(AstraXApp.astraX.getActiveUserProfile().playerName);
        return player;
    }

    public SatelliteTarget createPlayerSatellite(String shipName, AstraXFiles.AstraXFile satelliteGridFile, SatelliteGrid satelliteGrid) {
        SatelliteTarget playerTarget = AstraXApp.astraX.getFactoryByClass(SatelliteFactory.class).createTarget(shipName, satelliteGridFile, satelliteGrid);
        this.initPlayerSatellite(playerTarget);
        return playerTarget;
    }

    public void initPlayerSatellite(SatelliteTarget satelliteTarget) {
        Satellite playerSpaceCraft = (Satellite)satelliteTarget.getModel();
        playerSpaceCraft.setSimulationMode(Satellite.SimulationMode.PLAYER);
        SatelliteGraphics satelliteGraphics = (SatelliteGraphics)satelliteTarget.getGraphics();
        satelliteGraphics.setPlayer(true);
        PropulsionUserController propulsionUserController = new PropulsionUserController(playerSpaceCraft.getSystem(PropulsionSystem.class));
        propulsionUserController.setup(this.dataPack.getDataPackSettings().getKeyMapping("satelliteControls"));
        satelliteTarget.setPositionController(propulsionUserController);
        ((SatelliteGraphics)satelliteTarget.getGraphics()).addListener(propulsionUserController.getInputProcessor());
    }
}

