/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.AbstractTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.PropulsionSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.Thruster;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.SensorSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Orbit;
import com.neutronio.astrax.app.generator.NameSpace;
import com.neutronio.astrax.gfx.SatelliteGraphics;
import com.neutronio.astrax.util.MathUtil;
import com.neutronio.astrax.util.Vector2i;

public class SatelliteTarget
extends AbstractTarget<Satellite, SatelliteGraphics> {
    public SatelliteTarget(EntityID id) {
        super(id);
    }

    public SatelliteTarget(EntityID id, Satellite satellite, SatelliteGraphics graphics) {
        super(id, satellite, graphics);
    }

    public SatelliteTarget(EntityID id, NameSpace nameSpace, Satellite satellite, SatelliteGraphics graphics) {
        super(id, nameSpace, satellite, graphics);
    }

    public boolean isStationary() {
        return !((Satellite)this.getModel()).hasSystem(PropulsionSystem.class);
    }

    @Override
    public void select() {
        ((SatelliteGraphics)this.getGraphics()).select();
    }

    @Override
    public void deselect() {
        ((SatelliteGraphics)this.getGraphics()).deselect();
    }

    @Override
    public void update(float delta, float starSystemTime) {
        super.update(delta, starSystemTime);
        ((Satellite)this.getModel()).updateSystems(delta);
        ((SatelliteGraphics)this.getGraphics()).updateSound((Satellite)this.getModel());
        this.getPositionController().update(delta);
        if (this.getPositionController() instanceof Orbit) {
            Orbit orbit = (Orbit)this.getPositionController();
            ((SatelliteGraphics)this.getGraphics()).setPosition(orbit.getCurrentX(starSystemTime), orbit.getCurrentY(starSystemTime));
        }
        if (((Satellite)this.getModel()).hasSystem(PropulsionSystem.class)) {
            for (Vector2i location : ((SatelliteGraphics)this.graphics).getThrusterGraphicsKeys()) {
                Thruster thruster = ((Satellite)this.getModel()).getThruster(location);
                ((SatelliteGraphics)this.graphics).getThrusterGraphic(location).updateNozzle(thruster.getThrusterPowerFactor());
            }
            PropulsionSystem propulsionSystem = ((Satellite)this.getModel()).getSystem(PropulsionSystem.class);
            propulsionSystem.update(delta);
            if ((double)Math.abs(propulsionSystem.getTravelDirection().len()) > 0.004) {
                Vector2 lateralVelocity = MathUtil.getDirectionalVector(propulsionSystem.getTravelDirection().len(), (float)Math.toRadians(((SatelliteGraphics)this.getGraphics()).getRotation()));
                ((SatelliteGraphics)this.getGraphics()).addAction(Actions.moveBy(lateralVelocity.x, lateralVelocity.y, 0.5f, Interpolation.pow3));
            }
            if ((double)Math.abs(propulsionSystem.getRotationalForce()) > 0.001) {
                ((SatelliteGraphics)this.getGraphics()).addAction(Actions.rotateBy(propulsionSystem.getRotationalForce(), 0.2f, Interpolation.pow2));
            }
        }
        if (((Satellite)this.getModel()).hasSystem(SensorSystem.class)) {
            SensorSystem sensorSystem = ((Satellite)this.getModel()).getSystem(SensorSystem.class);
            sensorSystem.measureSpeed(delta, this.getWorldPositionX(), this.getWorldPositionY());
        }
    }

    @Override
    public String getName() {
        return ((Satellite)this.model).getName();
    }
}

