/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.GalaxyMapContext;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.World;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteHeader;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SavedSatellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.SensorSystem;
import com.neutronio.astrax.gfx.SatelliteGraphics;
import java.sql.SQLException;

public class SpawnManager {
    private GalaxyMapContext galaxyMapContext;
    private World world;

    public SpawnManager(GalaxyMapContext galaxyMapContext, World world) {
        this.galaxyMapContext = galaxyMapContext;
        this.world = world;
    }

    public void despawnTarget(Targetable targetable) {
        ((Actor)targetable.getGraphics()).remove();
    }

    public void spawnTarget(Targetable targetable, int x, int y) {
        this.spawnTarget(targetable, x, y, 0.0f);
    }

    public void spawnTarget(Targetable targetable, int x, int y, float rotation) {
        SatelliteTarget satelliteTarget;
        ((Actor)targetable.getGraphics()).setPosition(x, y);
        ((Actor)targetable.getGraphics()).addAction(Actions.rotateBy(rotation));
        this.world.getStage().addActor((Actor)targetable.getGraphics());
        if (targetable instanceof SatelliteTarget && !(satelliteTarget = (SatelliteTarget)targetable).isStationary()) {
            Satellite spaceCraft = (Satellite)satelliteTarget.getModel();
            spaceCraft.getSystem(SensorSystem.class).measureSpeed(1.0f, x, y);
            spaceCraft.getSystem(SensorSystem.class).measureSpeed(1.0f, x, y);
        }
    }

    public SatelliteTarget loadAndSpawnSatellite(int satelliteId) throws SQLException {
        SatelliteHeader satelliteHeader = this.galaxyMapContext.getSatelliteDAO().get(satelliteId);
        SavedSatellite savedSatellite = this.galaxyMapContext.getSatelliteDAO().getBinary(satelliteId);
        SatelliteFactory satelliteFactory = AstraXApp.astraX.getFactoryByClass(SatelliteFactory.class);
        SatelliteTarget satelliteTarget = satelliteFactory.create(satelliteHeader.uuid, savedSatellite);
        ((SatelliteGraphics)satelliteTarget.getGraphics()).addAction(Actions.rotateBy(satelliteHeader.rotation));
        this.spawnTarget(satelliteTarget, satelliteHeader.x, satelliteHeader.y);
        return satelliteTarget;
    }
}

