/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.neutronio.astrax.app.datapack.game.BookmarkManager;
import com.neutronio.astrax.app.datapack.game.GameLogic;
import com.neutronio.astrax.app.datapack.game.world.GalaxyMapContext;
import com.neutronio.astrax.app.datapack.game.world.Player;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.SpawnManager;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Galaxy;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Sector;
import com.neutronio.astrax.app.datapack.game.world.galaxy.SectorStream;
import com.neutronio.astrax.app.datapack.game.world.galaxy.SectorTracker;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.SensorSystem;
import com.neutronio.astrax.gfx.SatelliteGraphics;
import com.neutronio.astrax.gfx.StarSystemGraphics;
import com.neutronio.astrax.util.Vector2i;
import java.util.HashMap;
import java.util.Map;

public class World {
    private Galaxy galaxy;
    private com.badlogic.gdx.physics.box2d.World physicsWorld;
    private BookmarkManager bookmarkManager;
    private SectorTracker sectorTracker = new SectorTracker();
    private SectorStream sectorStream;
    private GalaxyMapContext galaxyMapContext;
    private SpawnManager spawnManager;
    private Player localPlayer;
    private Stage stage;
    private Map<Class, GameLogic> gameLogic = new HashMap<Class, GameLogic>();

    public World() {
        this.stage = new Stage();
        this.bookmarkManager = new BookmarkManager(this);
    }

    public void setGalaxyMapContext(GalaxyMapContext galaxyMapContext) {
        this.galaxyMapContext = galaxyMapContext;
    }

    public GalaxyMapContext getGalaxyMapContext() {
        return this.galaxyMapContext;
    }

    public <T extends GameLogic> void addGameLogic(T gameLogic) {
        if (gameLogic == null) {
            return;
        }
        this.gameLogic.put(gameLogic.getClass(), gameLogic);
    }

    public boolean hasGameLogic(Class<GameLogic> logicClass) {
        return this.gameLogic.containsKey(logicClass);
    }

    public <T extends GameLogic> T getGameLogic(Class<T> ofClass) {
        return (T)this.gameLogic.get(ofClass);
    }

    public Stage getStage() {
        return this.stage;
    }

    public BookmarkManager getBookmarkManager() {
        return this.bookmarkManager;
    }

    public void setSectorTracker(SectorTracker sectorTracker) {
        this.sectorTracker = sectorTracker;
    }

    public void setSectorStream(SectorStream sectorStream) {
        this.sectorStream = sectorStream;
    }

    public SectorStream getSectorStream() {
        return this.sectorStream;
    }

    public SectorTracker getSectorTracker() {
        return this.sectorTracker;
    }

    public SpawnManager getSpawnManager() {
        return this.spawnManager;
    }

    public void setSpawnManager(SpawnManager spawnManager) {
        this.spawnManager = spawnManager;
    }

    @Deprecated
    public void teleportToPosition(SatelliteTarget target, float worldX, float worldY) {
        if (!target.isStationary()) {
            ((SatelliteGraphics)target.getGraphics()).setPosition(worldX, worldY);
            Satellite spaceCraft = (Satellite)target.getModel();
            spaceCraft.getSystem(SensorSystem.class).measureSpeed(1.0f, worldX, worldY);
            spaceCraft.getSystem(SensorSystem.class).measureSpeed(1.0f, worldX, worldY);
        }
    }

    public Vector2 sectorToGlobalCoordinates(float positionInsideSectorX, float positionInsideSectorY) {
        Sector<StarSystem> currentSector = this.sectorStream.getCurrentSector();
        return new Vector2((float)(this.sectorTracker.getSectorBoundsX() * currentSector.getXCoordinates()) + positionInsideSectorX, (float)(this.sectorTracker.getSectorBoundsY() * currentSector.getYCoordinates()) + positionInsideSectorY);
    }

    public Vector2 sectorToGlobalCoordinates(int sectorX, int sectorY, float positionInsideSectorX, float positionInsideSectorY) {
        return new Vector2((float)(this.sectorTracker.getSectorBoundsX() * sectorX) + positionInsideSectorX, (float)(this.sectorTracker.getSectorBoundsY() * sectorY) + positionInsideSectorY);
    }

    public Vector2 globalToSectorPosition(float globalPositionX, float globalPositionY) {
        StarSystemGraphics graphics = this.sectorStream.getCurrentSector().getChunk().getGraphics();
        return new Vector2(globalPositionX - graphics.getX(), globalPositionY - graphics.getY());
    }

    public Vector2i globalSectorToWorldPosition(int sectorPositionX, int sectorPositionY) {
        int localX = (sectorPositionX - this.galaxyMapContext.getGalaxy().getWidth() / 2) * this.sectorTracker.getSectorBoundsX();
        int localY = (sectorPositionY - this.galaxyMapContext.getGalaxy().getHeight() / 2) * this.sectorTracker.getSectorBoundsX();
        return new Vector2i(localX, localY);
    }

    public void pollSector() {
        this.sectorTracker.checkSector(this.getLocalPlayer().getPlayerTarget().getWorldPositionX(), this.getLocalPlayer().getPlayerTarget().getWorldPositionY());
    }

    public Player getLocalPlayer() {
        return this.localPlayer;
    }

    public void setLocalPlayer(Player localPlayer) {
        this.localPlayer = localPlayer;
    }

    public Galaxy getGalaxy() {
        return this.galaxy;
    }

    public void setGalaxy(Galaxy galaxy) {
        this.galaxy = galaxy;
        this.galaxyMapContext.setGalaxy(galaxy);
    }

    public void dispose() {
        this.getGalaxyMapContext().getDatabase().closeConnection();
        this.stage.clear();
        this.stage = new Stage();
        this.spawnManager = null;
        this.sectorTracker = null;
        this.sectorStream = null;
        if (this.localPlayer != null) {
            this.localPlayer.dispose();
        }
        this.localPlayer = null;
        this.galaxy.dispose();
    }
}

